/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.bitbucket.spi;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bitbucket.auth.Authentication;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.business.insights.api.user.RequestContext;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class BitbucketRequestContext
implements RequestContext {
    @VisibleForTesting
    static final String SECURITY_ESCALATION_REASON = "Data Pipeline scheduled export";
    private static final String SERVICE_USER_NAME = "data.pipeline";
    private static final String SERVICE_USER_DISPLAY_NAME = "Data Pipeline Scheduler";
    private final AtomicReference<Authentication> userReference = new AtomicReference();
    private final AuthenticationService authenticationService;
    private final UserAdminService userAdminService;
    private final UserService userService;
    private final SecurityService securityService;

    public BitbucketRequestContext(AuthenticationService authenticationService, UserService userService, UserAdminService userAdminService, SecurityService securityService) {
        this.authenticationService = authenticationService;
        this.userService = userService;
        this.userAdminService = userAdminService;
        this.securityService = securityService;
    }

    @Override
    public void dumpThreadContextInfo() {
        Authentication applicationUser = this.authenticationService.get();
        this.userReference.set(applicationUser);
    }

    @Override
    public void runInCustomContext(Runnable action) {
        Authentication authentication = this.userReference.get();
        if (authentication.getUser().isPresent()) {
            this.authenticationService.set(authentication);
            action.run();
        } else {
            this.securityService.impersonating((ApplicationUser)this.getOrCreateServiceUser(), SECURITY_ESCALATION_REASON).withPermission(Permission.SYS_ADMIN).call(() -> {
                action.run();
                return null;
            });
        }
    }

    @Nonnull
    private synchronized ServiceUser getOrCreateServiceUser() {
        ServiceUser serviceUser = this.userService.getServiceUserByName(SERVICE_USER_NAME, true);
        if (serviceUser != null) {
            return serviceUser;
        }
        return this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().active(false)).name(SERVICE_USER_NAME)).displayName(SERVICE_USER_DISPLAY_NAME)).build());
    }
}

