/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.config;

import com.atlassian.business.insights.api.config.PropertiesProvider;
import com.atlassian.sal.api.ApplicationProperties;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SystemThenSalPropertiesProvider
implements PropertiesProvider {
    private final ApplicationProperties applicationProperties;

    public SystemThenSalPropertiesProvider(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public boolean getBoolean(@Nonnull String key) {
        Objects.requireNonNull(key);
        return Boolean.parseBoolean(this.getProperty(key));
    }

    @Override
    public boolean getBoolean(@Nonnull String key, boolean defaultValue) {
        Objects.requireNonNull(key, "key");
        return Boolean.parseBoolean(this.getProperty(key, String.valueOf(defaultValue)));
    }

    @Override
    @Nonnull
    public String getProperty(@Nonnull String key, @Nonnull String defaultValue) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(defaultValue, "defaultValue cannot be null");
        String propertyValue = this.getProperty(key);
        return this.isEmpty(propertyValue) ? defaultValue : propertyValue;
    }

    private boolean isEmpty(String propertyValue) {
        return propertyValue == null || propertyValue.length() == 0;
    }

    @Nullable
    private String getProperty(@Nonnull String key) {
        Objects.requireNonNull(key);
        String systemPropertyValue = System.getProperty(key);
        if (systemPropertyValue != null) {
            return systemPropertyValue;
        }
        try {
            return this.applicationProperties.getPropertyValue(key);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

