/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.dataset;

import com.atlassian.business.insights.api.dataset.DataChannel;
import com.atlassian.business.insights.api.dataset.Dataset;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DefaultDataset
implements Dataset {
    private final String datasetName;
    private final List<DataChannel> dataChannels;
    private final int version;
    private final boolean isDeprecated;

    public DefaultDataset(@Nonnull String datasetName, @Nonnull List<DataChannel> dataChannels, int version) {
        this(datasetName, dataChannels, version, false);
    }

    public DefaultDataset(@Nonnull String datasetName, @Nonnull List<DataChannel> dataChannels, int version, boolean isDeprecated) {
        this.datasetName = Objects.requireNonNull(datasetName, "datasetName must not be null");
        this.dataChannels = Objects.requireNonNull(dataChannels, "dataChannels must not be null");
        this.version = version;
        this.isDeprecated = isDeprecated;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.datasetName;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    @Nonnull
    public List<DataChannel> getChannels() {
        return this.dataChannels;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }
}

