/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.dataset;

import com.atlassian.business.insights.api.dataset.Dataset;
import com.atlassian.business.insights.api.dataset.DatasetProvider;
import com.atlassian.business.insights.api.schema.SchemaStatus;
import com.atlassian.business.insights.api.user.RequestContext;
import com.atlassian.business.insights.core.dataset.api.InternalDataset;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DefaultDatasetProvider
implements DatasetProvider {
    private final List<Dataset> datasets;

    public DefaultDatasetProvider(@Nonnull List<Dataset> datasets, RequestContext requestContext) {
        this.datasets = datasets;
        requestContext.dumpThreadContextInfo();
        requestContext.runInCustomContext(() -> this.getDefaultDataset());
    }

    @Override
    @Nonnull
    public Dataset getDefaultDataset() throws NoSuchElementException {
        return (Dataset)Iterables.getLast(this.getAllDatasets());
    }

    @Override
    @Nonnull
    public Optional<Dataset> getDataset(int version) {
        return this.getAllDatasets().stream().filter(dataset -> dataset.getVersion() == version).findFirst();
    }

    @Override
    @Nonnull
    public List<Dataset> getAllDatasets() {
        return DefaultDatasetProvider.filterEnabledDatasets(this.datasets);
    }

    @Override
    @Nonnull
    public SchemaStatus getSchemaStatus(int schemaVersion) {
        return this.getDataset(schemaVersion).map(dataset -> dataset.isDeprecated() ? SchemaStatus.DEPRECATED : SchemaStatus.ACTIVE).orElse(SchemaStatus.REMOVED);
    }

    private static List<Dataset> filterEnabledDatasets(List<Dataset> datasets) {
        return datasets.stream().filter(DefaultDatasetProvider::isDatasetEnabled).collect(Collectors.toList());
    }

    private static boolean isDatasetEnabled(Dataset dataset) {
        return !(dataset instanceof InternalDataset) || ((InternalDataset)dataset).isEnabled();
    }
}

