/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.extract;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class EntityPage<T> {
    private final int offset;
    private final int limit;
    private final List<T> values;

    private EntityPage(@Nonnull Builder<T> builder) {
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.values = builder.values;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public List<T> getValues() {
        return this.values;
    }

    public boolean isLastPage() {
        return this.values.isEmpty();
    }

    public static <S> Builder<S> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private int offset = 0;
        private int limit = 100;
        private List<T> values = Collections.emptyList();

        public Builder<T> offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder<T> limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder<T> values(@Nonnull List<T> values) {
            this.values = Objects.requireNonNull(values);
            return this;
        }

        public EntityPage<T> build() {
            return new EntityPage(this);
        }
    }
}

