/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.extract;

import com.atlassian.business.insights.core.extract.EntityPage;
import com.google.common.collect.AbstractIterator;
import java.util.List;
import java.util.function.BiFunction;

public class EntityPageIterator<T>
extends AbstractIterator<EntityPage<T>> {
    private final int pageSize;
    private final BiFunction<Integer, Integer, List<T>> fetchFunc;
    private EntityPage<T> currentEntityPage;

    public EntityPageIterator(int pageSize, BiFunction<Integer, Integer, List<T>> fetchFunc) {
        this.pageSize = pageSize;
        this.fetchFunc = fetchFunc;
    }

    protected EntityPage<T> computeNext() {
        int offset = 0;
        int limit = this.pageSize;
        if (this.currentEntityPage != null) {
            offset = this.currentEntityPage.getOffset() + this.currentEntityPage.getLimit();
        }
        this.currentEntityPage = EntityPage.builder().offset(offset).limit(limit).values(this.fetchFunc.apply(offset, limit)).build();
        if (this.currentEntityPage.isLastPage()) {
            return (EntityPage)this.endOfData();
        }
        return this.currentEntityPage;
    }
}

