/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.schema;

import com.atlassian.business.insights.api.schema.FileSchema;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ColumnFileSchema
implements FileSchema {
    private final LinkedHashMap<String, String> fields;
    private final String fileNamePrefix;

    public ColumnFileSchema(@Nonnull String fileNamePrefix, @Nonnull LinkedHashMap<String, String> fields) {
        this.fileNamePrefix = Objects.requireNonNull(fileNamePrefix);
        this.fields = Objects.requireNonNull(fields);
    }

    @Override
    @Nonnull
    public List<Map<String, Object>> computeEntries(@Nonnull Map<String, Object> serializedEntity) {
        Objects.requireNonNull(serializedEntity);
        HashMap<String, Object> row = new HashMap<String, Object>();
        for (Map.Entry<String, String> field : this.fields.entrySet()) {
            row.put(field.getValue(), serializedEntity.get(field.getKey()));
        }
        return ImmutableList.of(row);
    }

    @Override
    @Nonnull
    public LinkedHashMap<String, String> getFields() {
        return this.fields;
    }

    @Override
    @Nonnull
    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnFileSchema)) {
            return false;
        }
        ColumnFileSchema that = (ColumnFileSchema)o;
        return Objects.equals(this.fileNamePrefix, that.fileNamePrefix) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.fileNamePrefix);
    }
}

