/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.schema;

import com.atlassian.business.insights.api.schema.FileSchema;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class ProductComputedFileSchema
implements FileSchema {
    private final String fileNamePrefix;
    private final LinkedHashMap<String, String> fields;
    private final Function<Map<String, Object>, List<Map<String, Object>>> computeEntries;
    private final BooleanSupplier checkIsEnabled;

    public ProductComputedFileSchema(@Nonnull String fileNamePrefix, @Nonnull LinkedHashMap<String, String> fields, @Nonnull Function<Map<String, Object>, List<Map<String, Object>>> computeEntries, @Nonnull BooleanSupplier checkIsEnabled) {
        this.fileNamePrefix = Objects.requireNonNull(fileNamePrefix);
        this.fields = Objects.requireNonNull(fields);
        this.computeEntries = Objects.requireNonNull(computeEntries);
        this.checkIsEnabled = Objects.requireNonNull(checkIsEnabled);
    }

    @Override
    @Nonnull
    public List<Map<String, Object>> computeEntries(@Nonnull Map<String, Object> serializedEntity) {
        return this.computeEntries.apply(serializedEntity);
    }

    @Override
    @Nonnull
    public LinkedHashMap<String, String> getFields() {
        return this.fields;
    }

    @Override
    @Nonnull
    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    @Override
    public boolean isEnabled() {
        return this.checkIsEnabled.getAsBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductComputedFileSchema that = (ProductComputedFileSchema)o;
        return Objects.equals(this.fileNamePrefix, that.fileNamePrefix) && Objects.equals(this.fields, that.fields) && Objects.equals(this.computeEntries, that.computeEntries) && Objects.equals(this.checkIsEnabled, that.checkIsEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.fileNamePrefix, this.fields, this.computeEntries, this.checkIsEnabled);
    }
}

