/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.service.track;

import com.atlassian.annotations.VisibleForTesting;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ReflectionServiceTracker<T>
implements ServiceTrackerCustomizer<T, T> {
    private final BundleContext bundleContext;
    private final ServiceTracker<T, T> serviceTracker;
    private final Consumer<T> resolveConsumer;
    private final Consumer<T> retireConsumer;

    public ReflectionServiceTracker(BundleContext bundleContext, String osgiServiceClassName, Consumer<T> resolveConsumer, Consumer<T> retireConsumer) {
        this.bundleContext = bundleContext;
        this.resolveConsumer = resolveConsumer;
        this.retireConsumer = retireConsumer;
        this.serviceTracker = new ServiceTracker(bundleContext, osgiServiceClassName, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        ServiceReference existingServiceReference = bundleContext.getServiceReference(osgiServiceClassName);
        if (existingServiceReference != null) {
            resolveConsumer.accept(bundleContext.getService(existingServiceReference));
        }
    }

    @VisibleForTesting
    ReflectionServiceTracker(BundleContext bundleContext, ServiceTracker<T, T> serviceTracker, String osgiServiceClassName, Consumer<T> resolveConsumer, Consumer<T> retireConsumer) {
        this.bundleContext = bundleContext;
        this.resolveConsumer = resolveConsumer;
        this.retireConsumer = retireConsumer;
        this.serviceTracker = serviceTracker;
        serviceTracker.open();
        ServiceReference existingServiceReference = bundleContext.getServiceReference(osgiServiceClassName);
        if (existingServiceReference != null) {
            resolveConsumer.accept(bundleContext.getService(existingServiceReference));
        }
    }

    public void close() {
        try {
            this.serviceTracker.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public T addingService(ServiceReference<T> reference) {
        Object service = this.bundleContext.getService(reference);
        this.resolveConsumer.accept(service);
        return (T)service;
    }

    public void modifiedService(ServiceReference<T> reference, T service) {
    }

    public void removedService(ServiceReference<T> reference, T service) {
        this.retireConsumer.accept(service);
    }
}

