/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.core;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.vault.core.KeyValueUtilities;
import org.springframework.vault.core.ReactiveVaultKeyValueMetadataOperations;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.support.VaultMetadataRequest;
import org.springframework.vault.support.VaultMetadataResponse;
import reactor.core.publisher.Mono;

class ReactiveVaultKeyValueMetadataTemplate
implements ReactiveVaultKeyValueMetadataOperations {
    private final ReactiveVaultOperations vaultOperations;
    private final String path;

    ReactiveVaultKeyValueMetadataTemplate(ReactiveVaultOperations vaultOperations, String path) {
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null");
        this.vaultOperations = vaultOperations;
        this.path = path;
    }

    @Override
    public Mono<VaultMetadataResponse> get(String path) {
        return this.vaultOperations.read(this.getMetadataPath(path), Map.class).flatMap(response -> {
            Map data = (Map)response.getData();
            if (null == data) {
                return Mono.empty();
            }
            return Mono.just((Object)data);
        }).map(KeyValueUtilities::fromMap);
    }

    @Override
    public Mono<Void> put(String path, VaultMetadataRequest body) {
        Assert.notNull((Object)body, (String)"Body must not be null");
        return this.vaultOperations.write(this.getMetadataPath(path), body).then();
    }

    @Override
    public Mono<Void> delete(String path) {
        return this.vaultOperations.delete(this.getMetadataPath(path));
    }

    private String getMetadataPath(String path) {
        Assert.hasText((String)path, (String)"Path must not be empty");
        return this.path + "/metadata/" + path;
    }
}

