/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeowners;

import com.atlassian.bitbucket.internal.codeowners.SubgroupSelector;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeOwnerGroupSelectorUtils {
    private static final Logger log = LoggerFactory.getLogger(CodeOwnerGroupSelectorUtils.class);
    private static final Integer DEFAULT_RETURNED_USERS = 1;
    private static final Pattern SUBGROUP_SYNTAX = Pattern.compile("^@reviewer-group/.+:([/a-zA-Z0-9_.-]+)(\\(([(0-9]+)\\))?");
    private static final Pattern USER_COUNT_SYNTAX = Pattern.compile("\\(([0-9]+)\\)?");

    private CodeOwnerGroupSelectorUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    @Nonnull
    public static Collection<ApplicationUser> getReviewerGroupUsersWithAppliedSelector(@Nonnull ReviewerGroup reviewerGroup, @Nonnull String reviewerGroupIdentifier) {
        Objects.requireNonNull(reviewerGroup, "reviewerGroup");
        Objects.requireNonNull(reviewerGroupIdentifier, "reviewerGroupIdentifier");
        try {
            String subgroupSelectorName = reviewerGroupIdentifier;
            Matcher subgroupSelector = SUBGROUP_SYNTAX.matcher(reviewerGroupIdentifier);
            int maxReturnedUsers = DEFAULT_RETURNED_USERS;
            if (subgroupSelector.matches()) {
                subgroupSelectorName = subgroupSelector.group(1);
                if (USER_COUNT_SYNTAX.matcher(reviewerGroupIdentifier).find()) {
                    maxReturnedUsers = Integer.parseInt(subgroupSelector.group(3));
                }
            }
            switch (SubgroupSelector.fromString(subgroupSelectorName)) {
                case RANDOM: {
                    return CodeOwnerGroupSelectorUtils.randomSelectorStrategy(reviewerGroup, maxReturnedUsers);
                }
                case ALL: {
                    return reviewerGroup.getUsers();
                }
            }
            return Collections.emptySet();
        }
        catch (IllegalArgumentException exception) {
            log.debug("Invalid selector strategy provided. Expected one of: {}", (Object)SubgroupSelector.values());
            return Collections.emptySet();
        }
    }

    public static boolean hasSubgroupSelector(@Nonnull String codeOwnerIdentifier) {
        Objects.requireNonNull(codeOwnerIdentifier, "codeOwnerIdentifier");
        return SUBGROUP_SYNTAX.matcher(codeOwnerIdentifier).matches();
    }

    private static Collection<ApplicationUser> randomSelectorStrategy(ReviewerGroup reviewerGroup, int maxReturnedUsers) {
        ArrayList<ApplicationUser> userList = new ArrayList<ApplicationUser>(reviewerGroup.getUsers());
        Collections.shuffle(userList);
        if (maxReturnedUsers >= userList.size()) {
            return userList;
        }
        return userList.stream().limit(maxReturnedUsers).collect(Collectors.toList());
    }
}

