/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeowners;

import com.atlassian.bitbucket.internal.codeowners.CodeOwnerGroupSelectorUtils;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroupService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeOwnerUserResolver {
    private static final String REVIEWER_GROUP_PREFIX = "@reviewer-group/";
    private static final String USERNAME_PREFIX = "@";
    private static final Logger log = LoggerFactory.getLogger(CodeOwnerUserResolver.class);
    private final EmailValidator emailValidator;
    private final ReviewerGroupService reviewerGroupService;
    private final UserService userService;

    public CodeOwnerUserResolver(@Nonnull ReviewerGroupService reviewerGroupService, @Nonnull UserService userService) {
        this.reviewerGroupService = Objects.requireNonNull(reviewerGroupService, "reviewerGroupService");
        this.userService = Objects.requireNonNull(userService, "userService");
        this.emailValidator = new EmailValidator();
    }

    public static boolean isReviewerGroup(@Nonnull String identifier) {
        Objects.requireNonNull(identifier, "identifier");
        return identifier.startsWith(REVIEWER_GROUP_PREFIX);
    }

    @Nonnull
    public Collection<ApplicationUser> resolveIdentifier(@Nonnull String codeOwnerIdentifier, @Nonnull Repository repository) {
        Optional<ApplicationUser> user;
        Collection<ApplicationUser> groupUsers;
        Objects.requireNonNull(codeOwnerIdentifier, "ownerIdentifier");
        Objects.requireNonNull(repository, "repository");
        if (codeOwnerIdentifier.length() <= 1) {
            log.debug("Identifier {} could not be resolved as identifier must be at least 2 characters long", (Object)codeOwnerIdentifier);
            return Collections.emptySet();
        }
        if (CodeOwnerUserResolver.isReviewerGroup(codeOwnerIdentifier) && !(groupUsers = this.resolveGroupIdentifier(codeOwnerIdentifier.replaceAll("\\\\ ", " "), repository)).isEmpty()) {
            return groupUsers;
        }
        if (codeOwnerIdentifier.startsWith(USERNAME_PREFIX)) {
            user = Optional.ofNullable(this.userService.getUserByName(codeOwnerIdentifier.substring(1).replaceAll("\\\\ ", " ")));
            if (!user.isPresent()) {
                log.debug("Identifier {} could not be resolved as no user with a matching user slug could be found", (Object)codeOwnerIdentifier);
                return Collections.emptySet();
            }
            return Collections.singleton(user.get());
        }
        if (this.emailValidator.isValid((CharSequence)codeOwnerIdentifier, null)) {
            user = Optional.ofNullable(this.userService.findUserByEmail(codeOwnerIdentifier));
            if (!user.isPresent()) {
                log.debug("Identifier {} could not be resolved as no user with a matching email address could be found", (Object)codeOwnerIdentifier);
                return Collections.emptySet();
            }
            return Collections.singleton(user.get());
        }
        log.debug("Identifier {} could not be resolved as it is not a valid code owner identifier", (Object)codeOwnerIdentifier);
        return Collections.emptySet();
    }

    private Optional<ReviewerGroup> getReviewerGroup(String reviewerGroupName, Repository repository) {
        Optional reviewerGroup = this.reviewerGroupService.getByName((Scope)Scopes.repository((Repository)repository), reviewerGroupName);
        if (!reviewerGroup.isPresent() && !repository.getProject().getType().equals((Object)ProjectType.PERSONAL)) {
            reviewerGroup = this.reviewerGroupService.getByName((Scope)Scopes.project((Project)repository.getProject()), reviewerGroupName);
        }
        if (!reviewerGroup.isPresent()) {
            log.debug("Reviewer group {} could not be resolved as no reviewer group with a matching name could be found", (Object)reviewerGroupName);
            return Optional.empty();
        }
        return reviewerGroup;
    }

    private Collection<ApplicationUser> resolveGroupIdentifier(String codeOwnerIdentifier, Repository repository) {
        String reviewerGroupName = codeOwnerIdentifier.substring(REVIEWER_GROUP_PREFIX.length());
        if (CodeOwnerGroupSelectorUtils.hasSubgroupSelector(codeOwnerIdentifier)) {
            String reviewerGroupNameWithoutSyntax = reviewerGroupName.substring(0, reviewerGroupName.indexOf(58));
            Optional<ReviewerGroup> reviewerGroup = this.getReviewerGroup(reviewerGroupNameWithoutSyntax, repository);
            if (!reviewerGroup.isPresent()) {
                return Collections.emptySet();
            }
            return CodeOwnerGroupSelectorUtils.getReviewerGroupUsersWithAppliedSelector(reviewerGroup.get(), codeOwnerIdentifier);
        }
        return this.getReviewerGroup(reviewerGroupName, repository).map(ReviewerGroup::getUsers).orElse(Collections.emptySet());
    }
}

