/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeowners;

import com.atlassian.bitbucket.content.AbstractChangeCallback;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeSummary;
import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnerRule;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnerUserResolver;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class CodeOwnersChangeCallback
extends AbstractChangeCallback {
    private static final Logger log = LoggerFactory.getLogger(CodeOwnersChangeCallback.class);
    private final CodeOwnerUserResolver codeOwnerUserResolver;
    private final Map<Integer, List<String>> indexedMatchingOwnerIdentifiers;
    private final int maxCodeOwners;
    private final List<CodeOwnerRule> orderedRules;
    private final AntPathMatcher pathMatcher;
    private final PermissionService permissionService;
    private final List<ApplicationUser> resolvedOwners;
    private final Repository targetRepository;
    private boolean diffTruncated;
    private boolean groupSyntax;
    private boolean unresolvedUsersRemaining;

    public CodeOwnersChangeCallback(List<CodeOwnerRule> orderedRules, CodeOwnerUserResolver codeOwnerUserResolver, PermissionService permissionService, Repository targetRepository, int maxCodeOwners) {
        this.indexedMatchingOwnerIdentifiers = new HashMap<Integer, List<String>>(orderedRules.size());
        this.maxCodeOwners = maxCodeOwners;
        this.orderedRules = orderedRules;
        this.pathMatcher = new AntPathMatcher();
        this.permissionService = permissionService;
        this.resolvedOwners = new ArrayList<ApplicationUser>(maxCodeOwners);
        this.targetRepository = targetRepository;
        this.codeOwnerUserResolver = codeOwnerUserResolver;
    }

    public boolean hasGroupSyntax() {
        return this.groupSyntax;
    }

    public boolean hasUnresolvedUsers() {
        return this.unresolvedUsersRemaining;
    }

    public boolean isDiffTruncated() {
        return this.diffTruncated;
    }

    public boolean onChange(@Nonnull Change change) {
        this.addMatchingOwnersForPath(change.getPath().toString());
        if (change.getType() == ChangeType.MOVE && change.getSrcPath() != null) {
            this.addMatchingOwnersForPath(change.getSrcPath().toString());
        }
        return true;
    }

    public void onEnd(@Nonnull ChangeSummary summary) {
        this.diffTruncated = summary.isTruncated();
    }

    @Nonnull
    public List<ApplicationUser> resolveOwners() {
        List orderedOwnerIdentifiers = (List)this.indexedMatchingOwnerIdentifiers.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).flatMap(entry -> ((List)entry.getValue()).stream()).distinct().collect(MoreCollectors.toImmutableList());
        this.unresolvedUsersRemaining = false;
        Iterator identifierIterator = orderedOwnerIdentifiers.iterator();
        while (identifierIterator.hasNext() && this.resolvedOwners.size() < this.maxCodeOwners) {
            Iterator<ApplicationUser> userIterator;
            String codeOwnerIdentifier = (String)identifierIterator.next();
            Collection<ApplicationUser> identifiedUsers = this.codeOwnerUserResolver.resolveIdentifier(codeOwnerIdentifier, this.targetRepository);
            if (!this.groupSyntax && CodeOwnerUserResolver.isReviewerGroup(codeOwnerIdentifier)) {
                this.groupSyntax = true;
            }
            if (!(userIterator = identifiedUsers.iterator()).hasNext()) {
                this.unresolvedUsersRemaining = identifierIterator.hasNext();
            }
            while (userIterator.hasNext() && this.resolvedOwners.size() < this.maxCodeOwners) {
                ApplicationUser nextUser = userIterator.next();
                boolean bl = this.unresolvedUsersRemaining = userIterator.hasNext() || identifierIterator.hasNext();
                if (this.resolvedOwners.contains(nextUser) || !this.permissionService.hasRepositoryPermission(nextUser, this.targetRepository, Permission.REPO_READ) || !this.permissionService.hasGlobalPermission(nextUser, Permission.LICENSED_USER)) continue;
                this.resolvedOwners.add(nextUser);
            }
        }
        return Collections.unmodifiableList(this.resolvedOwners);
    }

    private void addMatchingOwnersForPath(String path) {
        ListIterator<CodeOwnerRule> iterator = this.orderedRules.listIterator();
        while (iterator.hasNext()) {
            CodeOwnerRule rule = iterator.next();
            if (!this.pathMatcher.match(rule.getPattern(), path)) continue;
            log.debug("Matching code owner rule at line {} found to match change {}", (Object)rule.getLineNumber(), (Object)path);
            this.indexedMatchingOwnerIdentifiers.put(iterator.previousIndex(), rule.getOwnerIdentifiers());
            return;
        }
        log.debug("No code owner rule found to match change {}", (Object)path);
    }
}

