/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeowners;

import com.atlassian.bitbucket.content.AbstractFileContentCallback;
import com.atlassian.bitbucket.content.FileSummary;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnerRule;
import com.atlassian.bitbucket.internal.codeowners.SimpleCodeOwnerRule;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeOwnersFileContentCallback
extends AbstractFileContentCallback {
    private static final String COMMENT_PREFIX = "#";
    private static final int CONTENT_SERVICE_PAGE_SIZE = 10000;
    private static final Pattern ESCAPED_SPACE = Pattern.compile("\\\\\\s");
    private static final Pattern LEADING_DIRECTORY_SLASH = Pattern.compile("^[\\\\/]");
    private static final Pattern SPACE_DELIMITER = Pattern.compile("(?<!\\\\)\\s+");
    private static final Pattern TRAILING_DIRECTORY_SLASH = Pattern.compile("[\\\\/]$");
    private static final Logger log = LoggerFactory.getLogger(CodeOwnersFileContentCallback.class);
    private final LinkedList<CodeOwnerRule> rules = new LinkedList();
    private boolean isLastPage = false;
    private PageRequest nextPageRequest = PageUtils.newRequest((int)0, (int)10000);

    public PageRequest getNextPageRequest() {
        return this.nextPageRequest;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public void onEnd(@Nonnull FileSummary summary) {
        this.isLastPage = summary.isLastPage();
        if (!this.isLastPage) {
            this.nextPageRequest = summary.getNextPageRequest();
        }
    }

    public boolean onLine(int lineNumber, String line, boolean truncated) {
        if (StringUtils.isBlank((CharSequence)(line = StringUtils.trimToEmpty((String)line))) || line.startsWith(COMMENT_PREFIX)) {
            return true;
        }
        List<String> configLineParts = Arrays.asList(SPACE_DELIMITER.split(line));
        int userCount = configLineParts.size() - 1;
        if (truncated) {
            log.debug("Truncated line in CODEOWNERS file found, removing last found owner");
            --userCount;
        }
        if (configLineParts.size() + userCount <= 0) {
            return true;
        }
        String path = CodeOwnersFileContentCallback.processPath(configLineParts.get(0));
        List users = (List)configLineParts.subList(1, userCount + 1).stream().distinct().map(CodeOwnersFileContentCallback::unescape).collect(MoreCollectors.toImmutableList());
        this.rules.addFirst(new SimpleCodeOwnerRule(users, path, lineNumber));
        return true;
    }

    public synchronized List<CodeOwnerRule> toCodeOwnerRules() {
        return Collections.unmodifiableList(this.rules);
    }

    private static String processPath(String path) {
        if (LEADING_DIRECTORY_SLASH.matcher((CharSequence)(path = CodeOwnersFileContentCallback.unescape((String)path))).find()) {
            path = LEADING_DIRECTORY_SLASH.matcher((CharSequence)path).replaceAll("");
        }
        if (TRAILING_DIRECTORY_SLASH.matcher((CharSequence)path).find()) {
            path = (String)path + "**";
        }
        return path;
    }

    private static String unescape(String value) {
        return ESCAPED_SPACE.matcher(value).replaceAll(" ");
    }
}

