/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeowners;

import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.content.NoSuchPathException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnerRule;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnersFileContentCallback;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnersFileException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public class CodeOwnersFileReader {
    private final String codeOwnersFilePath;
    private final ContentService contentService;
    private final I18nService i18nService;
    private final long maxCodeOwnersFileSize;

    public CodeOwnersFileReader(String codeOwnersFilePath, ContentService contentService, I18nService i18nService, long maxCodeOwnersFileSize) {
        this.codeOwnersFilePath = codeOwnersFilePath;
        this.contentService = contentService;
        this.i18nService = i18nService;
        this.maxCodeOwnersFileSize = maxCodeOwnersFileSize;
    }

    @Nonnull
    public List<CodeOwnerRule> getRules(@Nonnull Repository repository, @Nonnull Ref ref) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(ref, "ref");
        if (!this.hasValidFile(repository, ref)) {
            return Collections.emptyList();
        }
        CodeOwnersFileContentCallback fileContentCallback = new CodeOwnersFileContentCallback();
        do {
            this.contentService.streamFile(repository, ref.getId(), this.codeOwnersFilePath, fileContentCallback.getNextPageRequest(), false, (FileContentCallback)fileContentCallback);
        } while (!fileContentCallback.isLastPage());
        return fileContentCallback.toCodeOwnerRules();
    }

    private boolean hasValidFile(Repository repository, Ref ref) {
        OptionalLong pathSize;
        try {
            pathSize = this.contentService.getSize(repository, ref.getId(), this.codeOwnersFilePath);
        }
        catch (NoSuchPathException exception) {
            return false;
        }
        if (!pathSize.isPresent() || pathSize.getAsLong() == 0L) {
            return false;
        }
        if (pathSize.getAsLong() > this.maxCodeOwnersFileSize) {
            throw new CodeOwnersFileException(this.i18nService.createKeyedMessage("bitbucket.code.owners.error.file.exceeds.limit", new Object[0]));
        }
        return true;
    }
}

