/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeowners;

import com.atlassian.bitbucket.internal.codeowners.CodeOwnerRule;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnerUserResolver;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnersChangeCallback;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnersChangeCallbackFactory;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class DefaultCodeOwnersChangeCallbackFactory
implements CodeOwnersChangeCallbackFactory {
    private final int maxCodeOwners;
    private final PermissionService permissionService;
    private final CodeOwnerUserResolver userResolver;

    public DefaultCodeOwnersChangeCallbackFactory(int maxCodeOwners, PermissionService permissionService, CodeOwnerUserResolver userResolver) {
        this.maxCodeOwners = maxCodeOwners;
        this.permissionService = permissionService;
        this.userResolver = userResolver;
    }

    @Override
    @Nonnull
    public CodeOwnersChangeCallback create(@Nonnull List<CodeOwnerRule> orderedRules, @Nonnull Repository repository) {
        Objects.requireNonNull(orderedRules, "orderedRules");
        Objects.requireNonNull(repository, "repository");
        return new CodeOwnersChangeCallback(orderedRules, this.userResolver, this.permissionService, repository, this.maxCodeOwners);
    }
}

