/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeowners;

import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.compare.CompareService;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.dmz.codeowners.CodeOwnersRequest;
import com.atlassian.bitbucket.dmz.codeowners.CodeOwnersResponse;
import com.atlassian.bitbucket.dmz.codeowners.DmzCodeOwnersService;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnerRule;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnersChangeCallback;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnersChangeCallbackFactory;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnersFileException;
import com.atlassian.bitbucket.internal.codeowners.CodeOwnersFileReader;
import com.atlassian.bitbucket.internal.codeowners.event.CodeOwnersFileReadEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.NoSuchBranchException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.security.access.annotation.Secured;
import org.springframework.stereotype.Service;

@Service(value="codeOwnersService")
public class DefaultCodeOwnersService
implements DmzCodeOwnersService {
    private final CodeOwnersChangeCallbackFactory codeOwnersChangeCallbackFactory;
    private final CodeOwnersFileReader codeOwnersFileReader;
    private final CompareService compareService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final RefService refService;

    public DefaultCodeOwnersService(CodeOwnersChangeCallbackFactory codeOwnersChangeCallbackFactory, CompareService compareService, CodeOwnersFileReader codeOwnersFileReader, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, RefService refService) {
        this.codeOwnersChangeCallbackFactory = codeOwnersChangeCallbackFactory;
        this.compareService = compareService;
        this.eventPublisher = eventPublisher;
        this.codeOwnersFileReader = codeOwnersFileReader;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.refService = refService;
    }

    @Nonnull
    @RequireFeature(value=StandardFeature.CODE_OWNERS)
    @Secured(value={"Permission check performed internally"})
    public CodeOwnersResponse getCodeOwners(@Nonnull CodeOwnersRequest request) {
        List<CodeOwnerRule> rules;
        Objects.requireNonNull(request, "getRequest");
        Repository sourceRepository = request.getSourceRepository();
        Repository targetRepository = request.getTargetRepository();
        this.permissionValidationService.validateForRepository(sourceRepository, Permission.REPO_READ);
        if (!sourceRepository.equals((Object)targetRepository)) {
            this.permissionValidationService.validateForRepository(targetRepository, Permission.REPO_READ);
        }
        Ref sourceRef = this.resolveRef(request.getSourceRefId(), sourceRepository);
        Ref targetRef = this.resolveRef(request.getTargetRefId(), targetRepository);
        CompareRequest compareRequest = new CompareRequest.Builder().fromRef(sourceRef.getId(), sourceRepository).toRef(targetRef.getId(), targetRepository).build();
        try {
            rules = this.codeOwnersFileReader.getRules(request.getTargetRepository(), targetRef);
        }
        catch (CodeOwnersFileException fileException) {
            return new CodeOwnersResponse.Builder(fileException.getLocalizedMessage()).build();
        }
        return this.findMatchingCodeOwners(rules, compareRequest);
    }

    private CodeOwnersResponse findMatchingCodeOwners(List<CodeOwnerRule> rules, CompareRequest compareRequest) {
        if (rules.isEmpty()) {
            return new CodeOwnersResponse.Builder(Collections.emptyList()).build();
        }
        CodeOwnersChangeCallback changeCallback = this.codeOwnersChangeCallbackFactory.create(rules, compareRequest.getToRef().getRepository());
        this.compareService.streamChanges(compareRequest, (ChangeCallback)changeCallback);
        List<ApplicationUser> resolvedOwners = changeCallback.resolveOwners();
        this.eventPublisher.publish((Object)new CodeOwnersFileReadEvent(this, compareRequest.getToRef().getRepository(), resolvedOwners.size(), changeCallback.hasGroupSyntax()));
        CodeOwnersResponse.Builder responseBuilder = new CodeOwnersResponse.Builder(resolvedOwners);
        if (changeCallback.hasUnresolvedUsers()) {
            responseBuilder.errorMessage(this.i18nService.getMessage("bitbucket.code.owners.error.owners.exceeds.limit", new Object[0]));
        }
        return responseBuilder.build();
    }

    private Ref resolveRef(String refId, Repository repository) {
        Ref ref = this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(refId).build());
        if (ref == null) {
            throw new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.code.owners.error.invalid.ref", new Object[]{repository.getProject().getKey(), repository.getSlug(), refId}), refId);
        }
        return ref;
    }
}

