/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeowners;

import com.atlassian.bitbucket.internal.codeowners.CodeOwnerRule;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SimpleCodeOwnerRule
implements CodeOwnerRule {
    private final int lineNumber;
    private final List<String> ownerIdentifiers;
    private final String pattern;

    public SimpleCodeOwnerRule(@Nonnull List<String> ownerIdentifiers, @Nonnull String pattern, int lineNumber) {
        this.lineNumber = lineNumber;
        this.ownerIdentifiers = Objects.requireNonNull(ownerIdentifiers, "ownerIdentifiers");
        this.pattern = Objects.requireNonNull(pattern, "pattern");
    }

    public SimpleCodeOwnerRule(@Nonnull String ownerIdentifier, @Nonnull String pattern, int lineNumber) {
        this(Collections.singletonList(Objects.requireNonNull(ownerIdentifier, "ownerIdentifier")), pattern, lineNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCodeOwnerRule that = (SimpleCodeOwnerRule)o;
        return Objects.equals(this.ownerIdentifiers, that.ownerIdentifiers) && Objects.equals(this.pattern, that.pattern);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    @Nonnull
    public List<String> getOwnerIdentifiers() {
        return this.ownerIdentifiers;
    }

    @Override
    @Nonnull
    public String getPattern() {
        return this.pattern;
    }

    public int hashCode() {
        return Objects.hash(this.ownerIdentifiers, this.pattern);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ownerIdentifiers", this.ownerIdentifiers).add("pattern", (Object)this.pattern).toString();
    }
}

