/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit;

import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.ratelimit.DmzRateLimitSettingsService;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.internal.ratelimit.InternalRateLimitService;
import com.atlassian.bitbucket.internal.ratelimit.bucket.DefaultTokenBucket;
import com.atlassian.bitbucket.internal.ratelimit.bucket.TokenBucket;
import com.atlassian.bitbucket.internal.ratelimit.bucket.UnlimitedTokenBucket;
import com.atlassian.bitbucket.internal.ratelimit.history.HistoryIntervalManager;
import com.atlassian.bitbucket.internal.ratelimit.jmx.RateLimitStatisticsMXBean;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.management.ManagementFactory;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rateLimitService")
@RequireFeature(value=StandardFeature.RATE_LIMITING)
public class DefaultRateLimitService
implements InternalRateLimitService {
    @VisibleForTesting
    static final String MXBEAN_NAME = "com.atlassian.bitbucket:name=RateLimitStatistics";
    private static final Logger log = LoggerFactory.getLogger(DefaultRateLimitService.class);
    private final ConcurrentMap<Integer, TokenBucket> buckets;
    private final HistoryIntervalManager intervalManager;
    private final boolean jmxEnabled;
    private final AtomicLong rejectCount;
    private final Topic<Integer> settingsChangedTopic;
    private final DmzRateLimitSettingsService settingsService;
    private String subscriptionId;

    @Autowired
    public DefaultRateLimitService(HistoryIntervalManager intervalManager, ApplicationPropertiesService propertiesService, DmzRateLimitSettingsService settingsService, TopicService topicService) {
        this.intervalManager = intervalManager;
        this.settingsService = settingsService;
        this.buckets = new ConcurrentHashMap<Integer, TokenBucket>();
        this.jmxEnabled = propertiesService.isJmxEnabled();
        this.rejectCount = new AtomicLong();
        this.settingsChangedTopic = topicService.getTopic("ratelimit-settings-changed", new TopicSettings.Builder(Integer.class).dedupePendingMessages(true).build());
    }

    @PostConstruct
    public void onStart() {
        if (this.jmxEnabled) {
            this.registerMxBean();
        }
        this.subscriptionId = this.settingsChangedTopic.subscribe(event -> {
            int userId = (Integer)event.getMessage();
            if (userId < 0) {
                log.debug("Rate limit settings changed; clearing {} token buckets.", (Object)this.buckets.size());
                this.buckets.clear();
            } else {
                log.debug("Settings for user with id {} have changed; clearing user's token bucket.", (Object)userId);
                this.buckets.remove(userId);
            }
        });
    }

    @PreDestroy
    public void onStop() {
        if (this.subscriptionId != null) {
            this.settingsChangedTopic.unsubscribe(this.subscriptionId);
            this.subscriptionId = null;
        }
        if (this.jmxEnabled) {
            this.unregisterMxBean();
        }
    }

    @Override
    public void reap() {
        this.buckets.values().removeIf(TokenBucket::isFull);
    }

    @Override
    public boolean tryAcquire(ApplicationUser user) {
        TokenBucket userBucket = this.buckets.computeIfAbsent(user.getId(), ignored -> this.createTokenBucket(user));
        boolean acquired = userBucket.tryAcquire();
        if (!acquired) {
            this.onReject(user);
        }
        return acquired;
    }

    private TokenBucket createTokenBucket(ApplicationUser user) {
        Optional userSettings = this.settingsService.get(user);
        if (userSettings.isPresent() && ((UserRateLimitSettings)userSettings.get()).isWhitelisted()) {
            log.trace("User with id {} is whitelisted", (Object)user.getId());
            return new UnlimitedTokenBucket();
        }
        TokenBucketSettings settings = userSettings.map(us -> (TokenBucketSettings)us.getSettings().get()).orElseGet(() -> ((DmzRateLimitSettingsService)this.settingsService).getDefault());
        return new DefaultTokenBucket(settings);
    }

    private void onReject(ApplicationUser user) {
        this.rejectCount.incrementAndGet();
        this.intervalManager.onReject(user);
    }

    private void registerMxBean() {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(new RateLimitStatisticsMXBeanAdapter(), new ObjectName(MXBEAN_NAME));
        }
        catch (RuntimeException | JMException e) {
            log.warn("Could not register {}. Rate limiting details will not be available in JMX.", (Object)RateLimitStatisticsMXBean.class.getName(), (Object)e);
        }
    }

    private void unregisterMxBean() {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(MXBEAN_NAME));
        }
        catch (RuntimeException | JMException e) {
            log.warn("Failed to unregister {}", (Object)RateLimitStatisticsMXBean.class.getName(), (Object)e);
        }
    }

    private class RateLimitStatisticsMXBeanAdapter
    implements RateLimitStatisticsMXBean {
        private RateLimitStatisticsMXBeanAdapter() {
        }

        @Override
        public long getRejectedRequestCount() {
            return DefaultRateLimitService.this.rejectCount.get();
        }

        @Override
        public int getUserMapSize() {
            return DefaultRateLimitService.this.buckets.size();
        }
    }
}

