/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit;

import com.atlassian.bitbucket.internal.ratelimit.InternalRateLimitService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;

public class RateLimitReaperJob
implements ScheduledJobSource {
    private static final Duration INTERVAL = Duration.ofMinutes(15L);
    private static final JobId JOB_ID = JobId.of((String)RateLimitReaperJob.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)RateLimitReaperJob.class.getName());
    private final InternalRateLimitService rateLimitService;

    public RateLimitReaperJob(InternalRateLimitService rateLimitService) {
        this.rateLimitService = rateLimitService;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        RateLimitReaperJobRunner jobRunner = new RateLimitReaperJobRunner();
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)jobRunner);
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withParameters((Map)ImmutableMap.of((Object)"feature", (Object)StandardFeature.RATE_LIMITING)).withSchedule(Schedule.forInterval((long)INTERVAL.toMillis(), (Date)Date.from(ZonedDateTime.now().plus(INTERVAL).toInstant()))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private class RateLimitReaperJobRunner
    implements JobRunner {
        private RateLimitReaperJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            RateLimitReaperJob.this.rateLimitService.reap();
            return JobRunnerResponse.success();
        }
    }
}

