/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.stash.internal.ratelimit.InternalRateLimitSettingsService;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rateLimitSettingsSupportData")
public class RateLimitSettingsSupportData
extends RootLevelSupportDataAppender {
    private static final String RATE_LIMIT = "bitbucket.atst.ratelimit";
    private static final String ENABLED = "bitbucket.atst.ratelimit.enabled";
    private static final String FEATURE_ENABLED = "bitbucket.atst.ratelimit.feature.enabled";
    private static final String SETTINGS = "bitbucket.atst.ratelimit.settings";
    private static final String CAPACITY = "bitbucket.atst.ratelimit.settings.capacity";
    private static final String FILL_RATE = "bitbucket.atst.ratelimit.settings.fillrate";
    private static final String DEFAULT_SETTINGS = "bitbucket.atst.ratelimit.settings.default";
    private static final String USER_SETTINGS = "bitbucket.atst.ratelimit.settings.user";
    private static final String CUSTOM_SETTINGS = "bitbucket.atst.ratelimit.settings.user.custom";
    private static final String USERNAME = "bitbucket.atst.ratelimit.settings.user.username";
    private static final String WHITELISTED = "bitbucket.atst.ratelimit.settings.user.whitelisted";
    private final FeatureManager featureManager;
    private final InternalRateLimitSettingsService rateLimitSettingsService;

    @Autowired
    public RateLimitSettingsSupportData(FeatureManager featureManager, InternalRateLimitSettingsService rateLimitSettingsService) {
        this.featureManager = featureManager;
        this.rateLimitSettingsService = rateLimitSettingsService;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        SupportDataBuilder rateLimitSupportDataBuilder = supportDataBuilder.addCategory(RATE_LIMIT);
        if (!this.featureManager.isEnabled((Feature)StandardFeature.RATE_LIMITING)) {
            rateLimitSupportDataBuilder.addValue(FEATURE_ENABLED, "false");
            return;
        }
        rateLimitSupportDataBuilder.addValue(ENABLED, Boolean.toString(this.rateLimitSettingsService.isEnabled()));
        this.addDefaultSettings(rateLimitSupportDataBuilder);
        this.addUserSettings(rateLimitSupportDataBuilder);
    }

    private void addDefaultSettings(SupportDataBuilder supportDataBuilder) {
        TokenBucketSettings defaultSettings = this.rateLimitSettingsService.getDefault();
        supportDataBuilder.addCategory(DEFAULT_SETTINGS).addValue(CAPACITY, Integer.toString(defaultSettings.getCapacity())).addValue(FILL_RATE, Integer.toString(defaultSettings.getFillRate()));
    }

    private void addUserSettings(SupportDataBuilder supportDataBuilder) {
        SupportDataBuilder userSettingsBuilder = supportDataBuilder.addCategory(USER_SETTINGS);
        this.rateLimitSettingsService.forEachUserSettings(us -> {
            if (us.isWhitelisted()) {
                userSettingsBuilder.addCategory(WHITELISTED).addValue(USERNAME, us.getUser().getName());
            } else {
                TokenBucketSettings tokenBucketSettings = (TokenBucketSettings)us.getSettings().get();
                userSettingsBuilder.addCategory(CUSTOM_SETTINGS).addValue(USERNAME, us.getUser().getName()).addValue(CAPACITY, Integer.toString(tokenBucketSettings.getCapacity())).addValue(FILL_RATE, Integer.toString(tokenBucketSettings.getFillRate()));
            }
        });
    }
}

