/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsCreatedEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.ratelimit.settings.user.created")
public class AnalyticsUserRateLimitSettingsCreatedEvent
extends UserRateLimitSettingsCreatedEvent {
    public AnalyticsUserRateLimitSettingsCreatedEvent(@Nonnull UserRateLimitSettings createdSettings, @Nonnull Object source) {
        super(createdSettings, source);
    }

    @Nullable
    public Integer getCapacity() {
        return this.createdSettings.getSettings().map(TokenBucketSettings::getCapacity).orElse(null);
    }

    @Nullable
    public Integer getFillRate() {
        return this.createdSettings.getSettings().map(TokenBucketSettings::getFillRate).orElse(null);
    }

    @Nonnull
    public ApplicationUser getUserWithCustomSettings() {
        return this.createdSettings.getUser();
    }

    @Nullable
    public Boolean getWhitelisted() {
        return this.createdSettings.isWhitelisted() ? Boolean.TRUE : null;
    }
}

