/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsDeletedEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.ratelimit.settings.user.deleted")
public class AnalyticsUserRateLimitSettingsDeletedEvent
extends UserRateLimitSettingsDeletedEvent {
    public AnalyticsUserRateLimitSettingsDeletedEvent(@Nonnull UserRateLimitSettings deletedSettings, @Nonnull Object source) {
        super(deletedSettings, source);
    }

    @Nullable
    public Integer getCapacity() {
        return this.deletedSettings.getSettings().map(TokenBucketSettings::getCapacity).orElse(null);
    }

    @Nullable
    public Integer getFillRate() {
        return this.deletedSettings.getSettings().map(TokenBucketSettings::getFillRate).orElse(null);
    }

    @Nonnull
    public ApplicationUser getUserWithCustomSettings() {
        return this.deletedSettings.getUser();
    }

    @Nullable
    public Boolean getWhitelisted() {
        return this.deletedSettings.isWhitelisted() ? Boolean.TRUE : null;
    }
}

