/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsModifiedEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.ratelimit.settings.user.modified")
public class AnalyticsUserRateLimitSettingsModifiedEvent
extends UserRateLimitSettingsModifiedEvent {
    public AnalyticsUserRateLimitSettingsModifiedEvent(@Nonnull UserRateLimitSettings newSettings, @Nonnull UserRateLimitSettings oldSettings, @Nonnull Object source) {
        super(newSettings, oldSettings, source);
    }

    @Nullable
    public Integer getNewCapacity() {
        return this.newSettings.getSettings().map(TokenBucketSettings::getCapacity).orElse(null);
    }

    @Nullable
    public Integer getNewFillRate() {
        return this.newSettings.getSettings().map(TokenBucketSettings::getFillRate).orElse(null);
    }

    @Nullable
    public Boolean getNewWhitelisted() {
        return this.newSettings.isWhitelisted() ? Boolean.TRUE : null;
    }

    @Nullable
    public Integer getOldCapacity() {
        return this.oldSettings.getSettings().map(TokenBucketSettings::getCapacity).orElse(null);
    }

    @Nullable
    public Integer getOldFillRate() {
        return this.oldSettings.getSettings().map(TokenBucketSettings::getFillRate).orElse(null);
    }

    @Nullable
    public Boolean getOldWhitelisted() {
        return this.oldSettings.isWhitelisted() ? Boolean.TRUE : null;
    }

    @Nonnull
    public ApplicationUser getUserWithCustomSettings() {
        return this.newSettings.getUser();
    }
}

