/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.ratelimit.DefaultRateLimitSettingsModifiedEvent;
import com.atlassian.bitbucket.dmz.ratelimit.RateLimitingDisabledEvent;
import com.atlassian.bitbucket.dmz.ratelimit.RateLimitingEnabledEvent;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsCreatedEvent;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsDeletedEvent;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsModifiedEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RateLimitEventListener {
    @VisibleForTesting
    static final String ACTION_DEFAULT_SETTINGS_MODIFIED = "bitbucket.ratelimit.audit.action.defaultratelimitsettingschanged";
    @VisibleForTesting
    static final String ACTION_RATE_LIMITING_DISABLED = "bitbucket.ratelimit.audit.action.ratelimitingdisabled";
    @VisibleForTesting
    static final String ACTION_RATE_LIMITING_ENABLED = "bitbucket.ratelimit.audit.action.ratelimitingenabled";
    @VisibleForTesting
    static final String ACTION_RATE_LIMITING_SETTINGS_CREATED = "bitbucket.ratelimit.audit.action.usersettingscreated";
    @VisibleForTesting
    static final String ACTION_RATE_LIMITING_SETTINGS_DELETED = "bitbucket.ratelimit.audit.action.usersettingsdeleted";
    @VisibleForTesting
    static final String ACTION_RATE_LIMITING_SETTINGS_MODIFIED = "bitbucket.ratelimit.audit.action.usersettingsmodified";
    @VisibleForTesting
    static final String ATTR_CAPACITY = "bitbucket.ratelimit.audit.attribute.capacity";
    @VisibleForTesting
    static final String ATTR_FILL_RATE = "bitbucket.ratelimit.audit.attribute.fillrate";
    @VisibleForTesting
    static final String ATTR_WHITELISTED = "bitbucket.ratelimit.audit.attribute.whitelisted";
    @VisibleForTesting
    static final String KEY_CAPACITY = "bitbucket.ratelimit.audit.changedvalue.capacity";
    @VisibleForTesting
    static final String KEY_FILL_RATE = "bitbucket.ratelimit.audit.changedvalue.fillrate";
    @VisibleForTesting
    static final String KEY_WHITELISTED = "bitbucket.ratelimit.audit.changedvalue.whitelisted";
    private static final Logger log = LoggerFactory.getLogger(RateLimitEventListener.class);
    private final AuditService auditService;

    @Autowired
    public RateLimitEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onDefaultRateLimitSettingsModified(DefaultRateLimitSettingsModifiedEvent event) {
        int oldCapacity = event.getOldCapacity();
        int oldFillRate = event.getOldFillRate();
        int newFillRate = event.getNewFillRate();
        int newCapacity = event.getNewCapacity();
        if (oldCapacity != newCapacity || oldFillRate != newFillRate) {
            this.audit(ACTION_DEFAULT_SETTINGS_MODIFIED, builder -> builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_CAPACITY).from(Integer.toString(oldCapacity)).to(Integer.toString(newCapacity)).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_FILL_RATE).from(Integer.toString(oldFillRate)).to(Integer.toString(newFillRate)).build()));
        }
    }

    @EventListener
    public void onRateLimitingDisabled(RateLimitingDisabledEvent ignored) {
        this.audit(ACTION_RATE_LIMITING_DISABLED, builder -> {});
    }

    @EventListener
    public void onRateLimitingEnabled(RateLimitingEnabledEvent ignored) {
        this.audit(ACTION_RATE_LIMITING_ENABLED, builder -> {});
    }

    @EventListener
    public void onUserRateLimitSettingsCreated(UserRateLimitSettingsCreatedEvent event) {
        UserRateLimitSettings userSettings = event.getCreatedSettings();
        this.audit(ACTION_RATE_LIMITING_SETTINGS_CREATED, builder -> RateLimitEventListener.enrichWithUserSettings(builder, userSettings));
    }

    @EventListener
    public void onUserRateLimitSettingsDeleted(UserRateLimitSettingsDeletedEvent event) {
        UserRateLimitSettings userSettings = event.getDeletedSettings();
        this.audit(ACTION_RATE_LIMITING_SETTINGS_DELETED, builder -> RateLimitEventListener.enrichWithUserSettings(builder, userSettings));
    }

    @EventListener
    public void onUserRateLimitSettingsModified(UserRateLimitSettingsModifiedEvent event) {
        UserRateLimitSettings newSettings = event.getNewSettings();
        UserRateLimitSettings oldSettings = event.getOldSettings();
        Preconditions.checkArgument((boolean)Objects.equals(oldSettings.getUser(), newSettings.getUser()), (Object)"Given settings belong to two different users.");
        if (oldSettings.isWhitelisted() && newSettings.isWhitelisted()) {
            log.warn("{}: User settings have not changed.", (Object)newSettings.getUser().getName());
            return;
        }
        this.audit(ACTION_RATE_LIMITING_SETTINGS_MODIFIED, builder -> {
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_WHITELISTED).from(String.valueOf(oldSettings.isWhitelisted())).to(String.valueOf(newSettings.isWhitelisted())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_CAPACITY).from((String)oldSettings.getSettings().map(s -> String.valueOf(s.getCapacity())).orElse(null)).to((String)newSettings.getSettings().map(s -> String.valueOf(s.getCapacity())).orElse(null)).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)KEY_FILL_RATE).from((String)oldSettings.getSettings().map(s -> String.valueOf(s.getFillRate())).orElse(null)).to((String)newSettings.getSettings().map(s -> String.valueOf(s.getFillRate())).orElse(null)).build());
            builder.affectedObject(AuditUtils.auditResourceForUser((ApplicationUser)oldSettings.getUser()));
        });
    }

    private static void enrichWithUserSettings(AuditEvent.Builder builder, UserRateLimitSettings userSettings) {
        builder.affectedObject(AuditUtils.auditResourceForUser((ApplicationUser)userSettings.getUser())).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_WHITELISTED, (String)Boolean.toString(userSettings.isWhitelisted())).build());
        userSettings.getSettings().ifPresent(settings -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_CAPACITY, (String)Integer.toString(settings.getCapacity())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_FILL_RATE, (String)Integer.toString(settings.getFillRate())).build()));
    }

    private void audit(String action, Consumer<AuditEvent.Builder> eventSpecificFields) {
        AuditType type = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"bitbucket.service.audit.category.globaladministration", (String)action).build();
        AuditEvent.Builder builder = AuditEvent.builder((AuditType)type);
        eventSpecificFields.accept(builder);
        this.auditService.audit(builder.build());
    }
}

