/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.bucket;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.internal.ratelimit.bucket.TokenBucket;

public class DefaultTokenBucket
implements TokenBucket {
    private final TokenBucketSettings settings;
    private volatile long lastRefillTime;
    private volatile int tokens;

    public DefaultTokenBucket(TokenBucketSettings settings) {
        this.settings = settings;
        this.lastRefillTime = System.currentTimeMillis() / 1000L;
        this.tokens = settings.getCapacity();
    }

    public synchronized int getCount() {
        this.refill();
        return this.tokens;
    }

    @Override
    public synchronized boolean isFull() {
        this.refill();
        return this.tokens >= this.settings.getCapacity();
    }

    @Override
    public synchronized boolean tryAcquire() {
        if (this.tokens > 0) {
            --this.tokens;
            return true;
        }
        this.refill();
        if (this.tokens > 0) {
            --this.tokens;
            return true;
        }
        return false;
    }

    private void refill() {
        long now = System.currentTimeMillis() / 1000L;
        if (now > this.lastRefillTime) {
            int secondsSinceLastRefill = (int)(now - this.lastRefillTime);
            this.tokens = Math.min(this.settings.getCapacity(), this.tokens + secondsSinceLastRefill * this.settings.getFillRate());
            if (this.tokens < 0) {
                this.tokens = this.settings.getCapacity();
            }
            this.lastRefillTime = now;
        }
    }
}

