/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.dao;

import com.atlassian.bitbucket.dmz.ratelimit.AggregateRejectCounterOrder;
import com.atlassian.bitbucket.dmz.ratelimit.AggregateRejectCounterSearchRequest;
import com.atlassian.bitbucket.internal.ratelimit.dao.UserRateLimitCounterDao;
import com.atlassian.bitbucket.internal.ratelimit.model.InternalAggregateRejectCounter;
import com.atlassian.bitbucket.internal.ratelimit.model.UserRateLimitCounter;
import com.atlassian.bitbucket.internal.ratelimit.model.UserRateLimitCounter_;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import jakarta.annotation.Nonnull;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.Predicate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="rateLimitCounterDao")
public class HibernateUserRateLimitCounterDao
implements UserRateLimitCounterDao {
    private static final Predicate<InternalAggregateRejectCounter> IS_ACTIVE_USER = counter -> counter.getUser().isActive();
    private final SessionFactory sessionFactory;

    @Autowired
    public HibernateUserRateLimitCounterDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    @Nonnull
    public UserRateLimitCounter create(@Nonnull UserRateLimitCounter counter) {
        this.session().saveOrUpdate((Object)Objects.requireNonNull(counter, "counter"));
        return counter;
    }

    @Override
    public int deleteOlderThan(@Nonnull Duration duration) {
        return this.session().createQuery("DELETE FROM UserRateLimitCounter c WHERE c.intervalStart < :deadline").setParameter("deadline", (Object)LocalDateTime.now().minus(duration)).executeUpdate();
    }

    @Override
    public Page<InternalAggregateRejectCounter> getAggregateCounts(@Nonnull AggregateRejectCounterSearchRequest searchRequest, @Nonnull Duration duration, @Nonnull PageRequest page) {
        CriteriaQuery<InternalAggregateRejectCounter> criteriaQuery = HibernateUserRateLimitCounterDao.aggregateQuery(this.session().getCriteriaBuilder(), duration, searchRequest.getOrder());
        Query query = this.session().createQuery(criteriaQuery);
        return HibernateUtils.initializePage((Page)HibernatePageUtils.pageQuery((Query)query, (PageRequest)page, IS_ACTIVE_USER));
    }

    private static CriteriaQuery<InternalAggregateRejectCounter> aggregateQuery(CriteriaBuilder builder, Duration duration, AggregateRejectCounterOrder order) {
        CriteriaQuery query = builder.createQuery(InternalAggregateRejectCounter.class);
        Root from = query.from(UserRateLimitCounter.class);
        Path user = from.get(UserRateLimitCounter_.user);
        Path intervalStart = from.get(UserRateLimitCounter_.intervalStart);
        Expression newestRejection = builder.greatest((Expression)intervalStart);
        Expression totalRejectCount = builder.sum((Expression)from.get(UserRateLimitCounter_.rejectCount));
        return query.select((Selection)builder.construct(InternalAggregateRejectCounter.class, new Selection[]{user, newestRejection, totalRejectCount})).where((Expression)builder.greaterThanOrEqualTo((Expression)intervalStart, (Comparable)LocalDateTime.now().minus(duration))).orderBy(new Order[]{order == AggregateRejectCounterOrder.NEWEST ? builder.desc(newestRejection) : builder.desc(totalRejectCount)}).groupBy(new Expression[]{user});
    }

    private Session session() {
        return this.sessionFactory.getCurrentSession();
    }
}

