/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.dao;

import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsSearchRequest;
import com.atlassian.bitbucket.internal.ratelimit.dao.UserRateLimitSettingsDao;
import com.atlassian.bitbucket.internal.ratelimit.model.InternalUserRateLimitSettings;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.UserUtils;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="userRateLimitSettingsDao")
public class HibernateUserRateLimitSettingsDao
extends AbstractHibernateDao<Long, InternalUserRateLimitSettings>
implements UserRateLimitSettingsDao {
    private static final Predicate<InternalUserRateLimitSettings> IS_ACTIVE_USER = settings -> settings.getUser().isActive();

    @Autowired
    public HibernateUserRateLimitSettingsDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<InternalUserRateLimitSettings> findAll(PageRequest pageRequest) {
        String hql = "SELECT r FROM InternalUserRateLimitSettings r JOIN FETCH r.user\nORDER BY r.user.username ASC\n";
        Query query = this.session().createQuery(hql);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest));
    }

    @Nonnull
    public Page<InternalUserRateLimitSettings> findAll(PageRequest pageRequest, Predicate<? super InternalUserRateLimitSettings> predicate) {
        String hql = "SELECT r FROM InternalUserRateLimitSettings r JOIN FETCH r.user\nORDER BY r.user.username ASC\n";
        Query query = this.session().createQuery(hql);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest, predicate));
    }

    @Override
    @Nonnull
    public Optional<InternalUserRateLimitSettings> get(int userId) {
        String hql = "from InternalUserRateLimitSettings settings where settings.user.id = :userId";
        return this.session().createQuery(hql, InternalUserRateLimitSettings.class).setParameter("userId", (Object)userId).uniqueResultOptional().map(HibernateUtils::initialize);
    }

    @Nonnull
    public List<InternalUserRateLimitSettings> getByIds(@Nonnull Collection<Long> ids) {
        String hql = "SELECT r FROM InternalUserRateLimitSettings r JOIN FETCH r.user\nWHERE r.id in (:ids)\nORDER BY r.user.username ASC\n";
        return this.session().createQuery(hql).setParameterList("ids", ids).list();
    }

    @Override
    @Nonnull
    public Page<InternalUserRateLimitSettings> search(@Nonnull UserRateLimitSettingsSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        String hql = "SELECT r FROM InternalUserRateLimitSettings r JOIN FETCH r.user\nORDER BY r.user.username ASC\n";
        Predicate<InternalUserRateLimitSettings> settingsFilter = IS_ACTIVE_USER;
        String filter = IdentifierUtils.toLowerCase((String)request.getFilter());
        if (filter != null) {
            settingsFilter = settingsFilter.and(HibernateUserRateLimitSettingsDao.userFilter(filter));
        }
        Query query = this.session().createQuery(hql);
        return HibernateUtils.initializePage((Page)this.pageQuery(query, pageRequest, settingsFilter));
    }

    @Override
    @Nonnull
    public Stream<InternalUserRateLimitSettings> stream() {
        String hql = "from InternalUserRateLimitSettings order by user.id";
        return this.session().createQuery(hql, InternalUserRateLimitSettings.class).setCacheMode(CacheMode.GET).setFetchSize(100).setMaxResults(0x7FFFFFFE).stream().filter(IS_ACTIVE_USER).map(HibernateUtils::initialize);
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        throw new UnsupportedOperationException("We have overridden the functions that use this for ordering, so this method should never be called.");
    }

    private static Predicate<InternalUserRateLimitSettings> userFilter(String filter) {
        Pattern pattern = UserUtils.createNameMatchingPattern((String)filter);
        return settings -> {
            InternalApplicationUser user = settings.getUser();
            return pattern.matcher(user.getName()).find() || pattern.matcher(user.getDisplayName()).find() || StringUtils.isNotBlank((CharSequence)user.getEmailAddress()) && pattern.matcher(user.getEmailAddress()).find();
        };
    }
}

