/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.history;

import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.ratelimit.AggregateRejectCounter;
import com.atlassian.bitbucket.dmz.ratelimit.AggregateRejectCounterSearchRequest;
import com.atlassian.bitbucket.dmz.ratelimit.DmzAggregateRejectCounterSearchService;
import com.atlassian.bitbucket.internal.ratelimit.dao.UserRateLimitCounterDao;
import com.atlassian.bitbucket.internal.ratelimit.history.HistoryInterval;
import com.atlassian.bitbucket.internal.ratelimit.history.HistoryIntervalManager;
import com.atlassian.bitbucket.internal.ratelimit.history.InternalRateLimitHistoryService;
import com.atlassian.bitbucket.internal.ratelimit.model.UserRateLimitCounter;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=DmzAggregateRejectCounterSearchService.class)
@RequireFeature(value=StandardFeature.RATE_LIMITING)
@Service(value="rateLimitHistoryService")
@Transactional
public class DefaultRateLimitHistoryService
implements InternalRateLimitHistoryService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRateLimitHistoryService.class);
    private final UserRateLimitCounterDao counterDao;
    private final HistoryIntervalManager intervalManager;
    private final PermissionValidationService permissionValidationService;
    private final ApplicationUserDao userDao;

    @Autowired
    public DefaultRateLimitHistoryService(UserRateLimitCounterDao counterDao, HistoryIntervalManager intervalManager, PermissionValidationService permissionValidationService, ApplicationUserDao userDao) {
        this.counterDao = counterDao;
        this.intervalManager = intervalManager;
        this.permissionValidationService = permissionValidationService;
        this.userDao = userDao;
    }

    @Override
    public void cleanupHistory() {
        log.debug("Cleanup old rate limit history...");
        int deletedCounters = this.counterDao.deleteOlderThan(RETENTION_PERIOD);
        log.debug("Successfully deleted {} counters", (Object)deletedCounters);
    }

    @Override
    public void collectRejectHistory() {
        log.debug("Collecting counters...");
        HistoryInterval interval = this.intervalManager.collect();
        interval.getCounters().entrySet().stream().map(e -> this.makeCounter(interval.getStart(), (Integer)e.getKey(), (Long)e.getValue())).forEach(this.counterDao::create);
        log.debug("Successfully collected {} counters", (Object)interval.getCounters().size());
    }

    public Page<AggregateRejectCounter> getRejectCounters(@Nonnull AggregateRejectCounterSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(searchRequest);
        Objects.requireNonNull(pageRequest);
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        return PageUtils.asPageOf(AggregateRejectCounter.class, this.counterDao.getAggregateCounts(searchRequest, RETENTION_PERIOD, pageRequest));
    }

    private UserRateLimitCounter makeCounter(LocalDateTime start, int userId, long rejectCount) {
        return UserRateLimitCounter.forUser((InternalApplicationUser)this.userDao.loadById((Object)userId)).withIntervalStartedAt(start).withRejectCount(rejectCount).build();
    }
}

