/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.history;

import com.atlassian.bitbucket.internal.ratelimit.history.InternalRateLimitHistoryService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;

public class HistoryCleanupJob
implements ScheduledJobSource {
    private static final Duration FIRST_TIME_RUN = Duration.ofMinutes(15L);
    private static final JobId JOB_ID = JobId.of((String)HistoryCleanupJob.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)HistoryCleanupJob.class.getName());
    private final InternalRateLimitHistoryService historyService;

    public HistoryCleanupJob(InternalRateLimitHistoryService historyService) {
        this.historyService = historyService;
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        HistoryCleanupJobRunner jobRunner = new HistoryCleanupJobRunner();
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)jobRunner);
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)ImmutableMap.of((Object)"feature", (Object)StandardFeature.RATE_LIMITING)).withSchedule(Schedule.forInterval((long)InternalRateLimitHistoryService.RETENTION_PERIOD.toMillis(), (Date)Date.from(ZonedDateTime.now().plus(FIRST_TIME_RUN).toInstant()))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private class HistoryCleanupJobRunner
    implements JobRunner {
        private HistoryCleanupJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            HistoryCleanupJob.this.historyService.cleanupHistory();
            return JobRunnerResponse.success();
        }
    }
}

