/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.history;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HistoryInterval {
    private final ConcurrentHashMap<Integer, AtomicLong> counters = new ConcurrentHashMap();
    private final Instant start = Instant.now();

    private HistoryInterval() {
    }

    @Nonnull
    public Map<Integer, Long> getCounters() {
        return this.counters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()));
    }

    @Nonnull
    public LocalDateTime getStart() {
        return LocalDateTime.ofInstant(this.start, ZoneOffset.UTC);
    }

    @Nonnull
    static HistoryInterval create() {
        return new HistoryInterval();
    }

    @Nonnull
    HistoryInterval onRateLimit(int userId) {
        this.counters.computeIfAbsent(userId, id -> new AtomicLong(0L)).incrementAndGet();
        return this;
    }
}

