/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.history;

import com.atlassian.bitbucket.internal.ratelimit.history.HistoryInterval;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.springframework.stereotype.Component;

@Component(value="rateLimitHistoryIntervalManager")
@ThreadSafe
public class HistoryIntervalManager {
    private final ReadWriteLock LOCK = new ReentrantReadWriteLock(true);
    private HistoryInterval interval = HistoryInterval.create();

    @Nonnull
    public HistoryInterval collect() {
        return this.guard(this.LOCK.writeLock(), this::swap);
    }

    public void onReject(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        if (user.getType() == UserType.NORMAL) {
            this.guard(this.LOCK.readLock(), i -> i.onRateLimit(user.getId()));
        }
    }

    private HistoryInterval guard(Lock lock, Function<HistoryInterval, HistoryInterval> action) {
        try (LockGuard ignored = LockGuard.lock((Lock)lock);){
            HistoryInterval historyInterval = Objects.requireNonNull(action.apply(this.interval));
            return historyInterval;
        }
    }

    private HistoryInterval swap(HistoryInterval original) {
        this.interval = HistoryInterval.create();
        return original;
    }
}

