/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.model;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import java.util.Optional;

@Entity
@Table(name="bb_rl_user_settings", uniqueConstraints={@UniqueConstraint(name="uk_user_settings_user_id", columnNames={"user_id"})})
@TableGenerator(allocationSize=20, pkColumnValue="bb_rl_user_settings", name="rateLimitUserSettingsIdGenerator", table="id_sequence")
public class InternalUserRateLimitSettings
implements UserRateLimitSettings,
Initializable {
    public static final String ID_GEN = "rateLimitUserSettingsIdGenerator";
    public static final String TABLE = "bb_rl_user_settings";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="rateLimitUserSettingsIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="capacity", nullable=false)
    private int capacity;
    @Column(name="fill_rate", nullable=false)
    private int fillRate;
    @JoinColumn(name="user_id", foreignKey=@ForeignKey(name="fk_bb_rl_user_settings_user"), nullable=false, unique=true, updatable=false)
    @OneToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser user;
    @Column(name="whitelisted", nullable=false)
    private boolean whitelisted;

    protected InternalUserRateLimitSettings() {
        this.id = 0L;
    }

    private InternalUserRateLimitSettings(Builder builder) {
        this.capacity = builder.capacity;
        this.fillRate = builder.fillRate;
        this.id = builder.id;
        this.user = builder.user;
        this.whitelisted = builder.whitelisted;
    }

    @Nonnull
    public static Builder builder(@Nonnull ApplicationUser user) {
        return new Builder(user);
    }

    public Builder copy() {
        return new Builder(this);
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public Optional<TokenBucketSettings> getSettings() {
        return this.whitelisted ? Optional.empty() : Optional.of(new TokenBucketSettings.Builder().capacity(this.capacity).fillRate(this.fillRate).build());
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    public void initialize() {
        this.user = (InternalApplicationUser)HibernateUtils.initialize((Object)this.getUser());
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public static class Builder {
        private static final int NULL_PLACEHOLDER_VALUE = -1;
        private final long id;
        private final InternalApplicationUser user;
        private int capacity;
        private int fillRate;
        private boolean whitelisted;

        private Builder(@Nonnull ApplicationUser user) {
            this.user = InternalConverter.convertToInternalUser((ApplicationUser)Objects.requireNonNull(user, "user"));
            this.capacity = -1;
            this.fillRate = -1;
            this.id = 0L;
        }

        private Builder(@Nonnull InternalUserRateLimitSettings settings) {
            this.capacity = settings.capacity;
            this.fillRate = settings.fillRate;
            this.id = Objects.requireNonNull(settings, (String)"settings").id;
            this.user = InternalConverter.convertToInternalUser((ApplicationUser)((ApplicationUser)Objects.requireNonNull(settings.user, "settings.user")));
            this.whitelisted = settings.whitelisted;
        }

        public InternalUserRateLimitSettings build() {
            Preconditions.checkState((this.whitelisted || this.capacity != -1 && this.fillRate != -1 ? 1 : 0) != 0, (Object)"Either user is 'whitelisted' or valid rate limit settings must be provided");
            return new InternalUserRateLimitSettings(this);
        }

        public Builder whitelisted() {
            this.capacity = -1;
            this.fillRate = -1;
            this.whitelisted = true;
            return this;
        }

        public Builder withSettings(@Nonnull TokenBucketSettings settings) {
            Objects.requireNonNull(settings, "settings");
            this.capacity = settings.getCapacity();
            this.fillRate = settings.getFillRate();
            this.whitelisted = false;
            return this;
        }
    }
}

