/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.model;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.time.LocalDateTime;
import java.util.Objects;
import org.hibernate.annotations.Immutable;

@Entity
@Table(name="bb_rl_reject_counter")
@TableGenerator(name="rejectCounterGenerator", pkColumnValue="bb_rl_reject_counter", table="id_sequence", indexes={@Index(name="bb_rl_rej_cntr_intvl_start", columnList="interval_start"), @Index(name="bb_rl_rej_cntr_usr_id", columnList="user_id")})
@Immutable
public class UserRateLimitCounter
implements Initializable {
    public static final String ID_GEN = "rejectCounterGenerator";
    public static final String TABLE = "bb_rl_reject_counter";
    @Id
    @GeneratedValue(generator="rejectCounterGenerator", strategy=GenerationType.TABLE)
    @Column(name="id", nullable=false, unique=true)
    private final long id;
    @Column(name="interval_start", nullable=false, updatable=false)
    private final LocalDateTime intervalStart;
    @Column(name="reject_count", nullable=false, updatable=false)
    private final long rejectCount;
    @JoinColumn(name="user_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_rl_rejected_user"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalApplicationUser user;

    protected UserRateLimitCounter() {
        this.id = 0L;
        this.intervalStart = null;
        this.rejectCount = 0L;
        this.user = null;
    }

    private UserRateLimitCounter(Builder builder) {
        this.id = builder.id;
        this.intervalStart = builder.intervalStart;
        this.rejectCount = builder.rejectCount;
        this.user = builder.user;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public LocalDateTime getIntervalStart() {
        return Objects.requireNonNull(this.intervalStart, "intervalStart");
    }

    public long getRejectCount() {
        return this.rejectCount;
    }

    public InternalApplicationUser getUser() {
        return this.user;
    }

    public void initialize() {
        HibernateUtils.initialize((Object)this.getUser());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("userId", (Object)this.getUser()).add("intervalStart", (Object)this.getIntervalStart()).add("rejectCount", this.getRejectCount()).toString();
    }

    public static Builder forUser(InternalApplicationUser user) {
        return new Builder(user);
    }

    public static class Builder
    extends BuilderSupport {
        private final long id;
        private final InternalApplicationUser user;
        private LocalDateTime intervalStart;
        private long rejectCount;

        private Builder(InternalApplicationUser user) {
            this.id = 0L;
            this.user = user;
        }

        public UserRateLimitCounter build() {
            return new UserRateLimitCounter(this);
        }

        public Builder withIntervalStartedAt(@Nonnull LocalDateTime timestamp) {
            this.intervalStart = Objects.requireNonNull(timestamp, "timestamp");
            return this;
        }

        public Builder withRejectCount(long rejectCount) {
            this.rejectCount = rejectCount;
            return this;
        }
    }
}

