/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.servlet.filter;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.ratelimit.DmzRateLimitSettingsService;
import com.atlassian.bitbucket.internal.ratelimit.InternalRateLimitService;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.concurrent.Gate;
import com.atlassian.stash.internal.maintenance.MaintenanceService;
import com.atlassian.stash.internal.maintenance.latch.LatchState;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RateLimitFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RateLimitFilter.class);
    private final AuthenticationContext authenticationContext;
    private final Gate<Integer> gate;
    private final MaintenanceService maintenanceService;
    private final InternalRateLimitService rateLimitService;
    private final DmzRateLimitSettingsService rateLimitSettingsService;
    private final RequestContext requestContext;

    @Autowired
    public RateLimitFilter(AuthenticationContext authenticationContext, InternalRateLimitService rateLimitService, DmzRateLimitSettingsService rateLimitSettingsService, MaintenanceService maintenanceService, RequestContext requestContext) {
        this.authenticationContext = authenticationContext;
        this.rateLimitService = rateLimitService;
        this.rateLimitSettingsService = rateLimitSettingsService;
        this.maintenanceService = maintenanceService;
        this.requestContext = requestContext;
        this.gate = new Gate(5L, TimeUnit.MINUTES);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isDatabaseAvailable() && this.rateLimitSettingsService.isEnabled()) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            ApplicationUser user = this.authenticationContext.getCurrentUser();
            if (user != null && RateLimitFilter.isBasicAuthOrToken(httpRequest) && !this.rateLimitService.tryAcquire(user)) {
                if (this.requestContext.isActive()) {
                    this.requestContext.addLabel("rate-limited");
                }
                if (log.isDebugEnabled()) {
                    this.gate.callIfNotRecentlyRun((Object)user.getId(), () -> log.debug("User '{}' has been rate limited", (Object)user.getSlug()));
                }
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.addHeader("Retry-After", "5");
                httpResponse.sendError(429, "Rate limit exceeded");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }

    private static boolean isBasicAuthOrToken(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            String lower = authHeader.toLowerCase(Locale.ROOT);
            return lower.startsWith("basic") || lower.startsWith("bearer");
        }
        return false;
    }

    private boolean isDatabaseAvailable() {
        return this.maintenanceService.getStatus().getDatabaseState() == LatchState.AVAILABLE;
    }
}

