/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ratelimit.settings;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.ratelimit.DmzRateLimitSettingsService;
import com.atlassian.bitbucket.dmz.ratelimit.RateLimitingDisabledEvent;
import com.atlassian.bitbucket.dmz.ratelimit.RateLimitingEnabledEvent;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsSearchRequest;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettingsUpdateRequest;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ratelimit.analytics.AnalyticsUserRateLimitSettingsCreatedEvent;
import com.atlassian.bitbucket.internal.ratelimit.analytics.AnalyticsUserRateLimitSettingsDeletedEvent;
import com.atlassian.bitbucket.internal.ratelimit.analytics.AnalyticsUserRateLimitSettingsModifiedEvent;
import com.atlassian.bitbucket.internal.ratelimit.dao.UserRateLimitSettingsDao;
import com.atlassian.bitbucket.internal.ratelimit.model.InternalUserRateLimitSettings;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.ratelimit.InternalRateLimitSettingsService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

@AvailableToPlugins(value=DmzRateLimitSettingsService.class)
@RequireFeature(value=StandardFeature.RATE_LIMITING)
@Service(value="rateLimitSettingsService")
@Transactional(readOnly=true)
public class DefaultRateLimitSettingsService
implements InternalRateLimitSettingsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRateLimitSettingsService.class);
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final InternalApplicationPropertiesService propertiesService;
    private final Topic<Integer> settingsChangedTopic;
    private final TransactionSynchronizer transactionSynchronizer;
    private final UserRateLimitSettingsDao userSettingsDao;

    @Autowired
    public DefaultRateLimitSettingsService(AuthenticationContext authenticationContext, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, PermissionValidationService permissionValidationService, InternalApplicationPropertiesService propertiesService, TopicService topicService, TransactionSynchronizer transactionSynchronizer, UserRateLimitSettingsDao userSettingsDao) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.propertiesService = propertiesService;
        this.transactionSynchronizer = transactionSynchronizer;
        this.userSettingsDao = userSettingsDao;
        this.settingsChangedTopic = topicService.getTopic("ratelimit-settings-changed", new TopicSettings.Builder(Integer.class).dedupePendingMessages(true).build());
    }

    @Transactional
    public boolean delete(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        this.validateNormalUser(user);
        Optional<InternalUserRateLimitSettings> deletedSettings = this.deleteInternal(user);
        if (deletedSettings.isPresent()) {
            this.eventPublisher.publish((Object)new AnalyticsUserRateLimitSettingsDeletedEvent(deletedSettings.get(), this));
            this.publishSettingsChangedMessage(user.getId());
            return true;
        }
        return false;
    }

    public void forEachUserSettings(@Nonnull Consumer<UserRateLimitSettings> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        try (Stream<InternalUserRateLimitSettings> stream = this.userSettingsDao.stream();){
            stream.forEach(consumer);
        }
    }

    @Nonnull
    public Optional<UserRateLimitSettings> get(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user, "user");
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.ratelimit.settings.user.insufficient.permission", new Object[0]));
        }
        if (!ApplicationUserEquality.equals((ApplicationUser)user, (Object)currentUser)) {
            this.permissionValidationService.validateForUser(user.getId(), Permission.USER_ADMIN);
        }
        if (user.getType() == UserType.SERVICE) {
            return Optional.empty();
        }
        return this.userSettingsDao.get(user.getId()).map(Function.identity());
    }

    @Nonnull
    @Transactional
    public TokenBucketSettings getDefault() {
        this.permissionValidationService.validateForGlobal(Permission.LICENSED_USER);
        return this.propertiesService.getDefaultRateLimitSettings();
    }

    @RequireFeature(value=StandardFeature.RATE_LIMITING, skip=true)
    public boolean isEnabled() {
        return this.propertiesService.isRateLimitEnabled() && this.featureManager.isEnabled((Feature)StandardFeature.RATE_LIMITING);
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        this.deleteInternal(event.getDeletedUser()).ifPresent(settings -> log.debug("Cleaned up custom settings for deleted user: {}", (Object)settings.getUser().getName()));
    }

    @Nonnull
    public Page<UserRateLimitSettings> search(@Nonnull UserRateLimitSettingsSearchRequest request, @Nonnull PageRequest pageRequest) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        return PageUtils.asPageOf(UserRateLimitSettings.class, this.userSettingsDao.search(Objects.requireNonNull(request, "request"), Objects.requireNonNull(pageRequest, "pageRequest")));
    }

    @Transactional
    public void set(@Nonnull Iterable<ApplicationUser> users, @Nonnull UserRateLimitSettingsUpdateRequest request) {
        Objects.requireNonNull(users, "users");
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        users.forEach(this::validateNormalUser);
        users.forEach(this.setCustomSettingsOrWhitelistUser(Objects.requireNonNull(request, "request")));
    }

    @Transactional
    public void set(@Nonnull ApplicationUser user, @Nonnull UserRateLimitSettingsUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        this.validateNormalUser(user);
        this.setCustomSettingsOrWhitelistUser(request).accept(user);
    }

    @Transactional
    public void setDefault(@Nonnull TokenBucketSettings settings) {
        if (this.propertiesService.setDefaultRateLimitSettings(settings)) {
            log.debug("Default rate limit settings updated: capacity={}, fillRate={}", (Object)settings.getCapacity(), (Object)settings.getFillRate());
            this.publishSettingsChangedMessage(-1);
        }
    }

    @Transactional
    public void setEnabled(boolean enabled) {
        boolean previousEnabled = this.propertiesService.isRateLimitEnabled();
        if (enabled != previousEnabled) {
            this.propertiesService.setRateLimitEnabled(enabled);
            this.eventPublisher.publish(enabled ? new RateLimitingEnabledEvent((Object)this) : new RateLimitingDisabledEvent((Object)this));
            if (!enabled) {
                this.publishSettingsChangedMessage(-1);
            }
        }
    }

    private void createUserSettings(InternalUserRateLimitSettings settings) {
        this.userSettingsDao.create(settings);
        this.eventPublisher.publish((Object)new AnalyticsUserRateLimitSettingsCreatedEvent(settings, this));
    }

    private Optional<InternalUserRateLimitSettings> deleteInternal(ApplicationUser user) {
        Optional<InternalUserRateLimitSettings> settings = this.userSettingsDao.get(user.getId());
        settings.ifPresent(arg_0 -> ((UserRateLimitSettingsDao)this.userSettingsDao).delete(arg_0));
        return settings;
    }

    private void publishSettingsChangedMessage(final int messageLoad) {
        this.transactionSynchronizer.register((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                DefaultRateLimitSettingsService.this.settingsChangedTopic.publish((Serializable)Integer.valueOf(messageLoad));
            }
        });
    }

    private void setCustomSettings(ApplicationUser user, TokenBucketSettings settings) {
        int userId = user.getId();
        Optional<InternalUserRateLimitSettings> existing = this.userSettingsDao.get(userId);
        if (existing.isPresent()) {
            InternalUserRateLimitSettings oldSettings = existing.get();
            if (oldSettings.getSettings().filter(tbs -> Objects.equals(tbs, settings)).isPresent()) {
                log.debug("User settings have not changed: (userId={}, settings={})", (Object)userId, oldSettings.getSettings());
                return;
            }
            this.updateUserSettings(oldSettings, oldSettings.copy().withSettings(settings).build());
        } else {
            this.createUserSettings(InternalUserRateLimitSettings.builder(user).withSettings(settings).build());
        }
        this.publishSettingsChangedMessage(userId);
    }

    private Consumer<ApplicationUser> setCustomSettingsOrWhitelistUser(UserRateLimitSettingsUpdateRequest request) {
        Preconditions.checkArgument((request.isWhitelisted() || request.getSettings().isPresent() ? 1 : 0) != 0, (Object)"Either user is whitelisted or valid token bucket settings must be provided.");
        return request.isWhitelisted() ? this::whitelistUser : user -> this.setCustomSettings((ApplicationUser)user, (TokenBucketSettings)request.getSettings().get());
    }

    private void updateUserSettings(InternalUserRateLimitSettings oldSettings, InternalUserRateLimitSettings newSettings) {
        InternalUserRateLimitSettings copyOfOldSettings = oldSettings.copy().build();
        this.userSettingsDao.update(newSettings);
        this.eventPublisher.publish((Object)new AnalyticsUserRateLimitSettingsModifiedEvent(newSettings, copyOfOldSettings, this));
    }

    private void validateNormalUser(ApplicationUser user) {
        if (user.getType() != UserType.NORMAL) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.ratelimit.settings.user.not.found", new Object[]{user.getSlug()}), user.getSlug());
        }
    }

    private void whitelistUser(ApplicationUser user) {
        int userId = user.getId();
        Optional<InternalUserRateLimitSettings> existing = this.userSettingsDao.get(userId);
        if (existing.isPresent()) {
            InternalUserRateLimitSettings oldSettings = existing.get();
            if (oldSettings.isWhitelisted()) {
                log.debug("User was already whitelisted: (userId={})", (Object)userId);
                return;
            }
            this.updateUserSettings(oldSettings, oldSettings.copy().whitelisted().build());
        } else {
            this.createUserSettings(InternalUserRateLimitSettings.builder(user).whitelisted().build());
        }
        this.publishSettingsChangedMessage(userId);
    }
}

