/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.bitbucket.dmz.ratelimit.DmzRateLimitSettingsService;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.soy.springmvc.SoyResponseBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin/rate-limit"})
@WebSudoRequired
public class RateLimitSettingsController {
    private static final String RATE_LIMIT_SETTINGS_VIEW = "bitbucket.internal.page.admin.ratelimit.rateLimitSettings.init";
    private final FeatureManager featureManager;
    private final DmzRateLimitSettingsService rateLimitSettingsService;

    public RateLimitSettingsController(FeatureManager featureManager, DmzRateLimitSettingsService rateLimitSettingsService) {
        this.featureManager = featureManager;
        this.rateLimitSettingsService = rateLimitSettingsService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView rateLimitSettings() {
        boolean rateLimitFeatureEnabled = this.featureManager.isEnabled((Feature)StandardFeature.RATE_LIMITING);
        RateLimitSettingsData.Builder builder = new RateLimitSettingsData.Builder(rateLimitFeatureEnabled);
        if (rateLimitFeatureEnabled) {
            builder.defaultSettings(this.rateLimitSettingsService.getDefault()).rateLimitingEnabled(this.rateLimitSettingsService.isEnabled()).recommendedSettings(TokenBucketSettings.recommendedSettings);
        }
        return ((SoyResponseBuilder)new SoyResponseBuilder(RATE_LIMIT_SETTINGS_VIEW).put("data", (Object)builder.build())).build();
    }

    static class RateLimitSettingsData {
        private final TokenBucketSettings defaultSettings;
        private final boolean rateLimitFeatureEnabled;
        private final Boolean rateLimitingEnabled;
        private final TokenBucketSettings recommendedSettings;

        private RateLimitSettingsData(Builder builder) {
            this.defaultSettings = builder.defaultSettings;
            this.rateLimitFeatureEnabled = builder.rateLimitFeatureEnabled;
            this.rateLimitingEnabled = builder.rateLimitingEnabled;
            this.recommendedSettings = builder.recommendedSettings;
        }

        @Nullable
        public TokenBucketSettings getDefaultSettings() {
            return this.defaultSettings;
        }

        @Nullable
        public TokenBucketSettings getRecommendedSettings() {
            return this.recommendedSettings;
        }

        public boolean isRateLimitFeatureEnabled() {
            return this.rateLimitFeatureEnabled;
        }

        @Nullable
        public Boolean isRateLimitingEnabled() {
            return this.rateLimitingEnabled;
        }

        private static class Builder {
            private final boolean rateLimitFeatureEnabled;
            private TokenBucketSettings defaultSettings;
            private Boolean rateLimitingEnabled;
            private TokenBucketSettings recommendedSettings;

            Builder(boolean rateLimitFeatureEnabled) {
                this.rateLimitFeatureEnabled = rateLimitFeatureEnabled;
            }

            @Nonnull
            RateLimitSettingsData build() {
                return new RateLimitSettingsData(this);
            }

            @Nonnull
            Builder defaultSettings(@Nullable TokenBucketSettings value) {
                this.defaultSettings = value;
                return this;
            }

            @Nonnull
            Builder rateLimitingEnabled(@Nullable Boolean value) {
                this.rateLimitingEnabled = value;
                return this;
            }

            @Nonnull
            Builder recommendedSettings(@Nonnull TokenBucketSettings value) {
                this.recommendedSettings = value;
                return this;
            }
        }
    }
}

