/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service;

import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceConfiguration;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceType;
import com.atlassian.secrets.service.DefaultSecretServiceManagement;
import com.atlassian.secrets.service.SecretServiceBackend;
import com.atlassian.secrets.service.SecretServiceParams;
import com.atlassian.secrets.service.clusterlock.ClusterLockOperator;
import com.atlassian.secrets.service.clusterlock.DefaultClusterLockOperator;
import com.atlassian.secrets.service.config.SecretServiceConfig;
import com.atlassian.secrets.service.internal.DefaultSecretServiceInterface;
import com.atlassian.secrets.service.internal.SecretBackendContainer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultSecretService
implements SecretService,
DefaultSecretServiceInterface {
    private static final int MAX_SECRET_SIZE = 65536;
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretService.class);
    private final SecretDao secretDao;
    private final SecretBackendContainer backends;
    private final SecretService.SecretServiceManagement secretServiceManagement;
    private final ClusterLockOperator clusterLockOperator;

    public DefaultSecretService(SecretServiceParams params, Map<String, SecretServiceBackend> backends, String defaultBackendId) {
        this.secretDao = params.getSecretDao();
        this.backends = new SecretBackendContainer(backends, defaultBackendId);
        this.secretServiceManagement = new DefaultSecretServiceManagement(this, params);
        this.clusterLockOperator = new DefaultClusterLockOperator(params.getClusterLockServiceSupplier());
    }

    DefaultSecretService(SecretServiceParams params, Map<String, SecretServiceBackend> backends, String defaultBackendId, SecretService.SecretServiceManagement secretServiceManagement) {
        this.secretDao = params.getSecretDao();
        this.backends = new SecretBackendContainer(backends, defaultBackendId);
        this.secretServiceManagement = secretServiceManagement;
        this.clusterLockOperator = new DefaultClusterLockOperator(params.getClusterLockServiceSupplier());
    }

    private static void validateSecretDataSize(String plainTextToSecure) throws SecretServiceException {
        byte[] dataInBytes = plainTextToSecure.getBytes(StandardCharsets.UTF_8);
        if (dataInBytes.length > 65536) {
            throw new SecretServiceException("Secret data size exceeds the 64KB limit.");
        }
    }

    public void put(String identifier, String data) throws SecretServiceException {
        Assert.hasText((String)identifier, (String)"Secret identifier must not be empty.");
        this.put(Collections.singletonMap(identifier, data));
    }

    public void put(Map<String, String> secrets) throws SecretServiceException {
        Assert.notNull(secrets, (String)"Secrets map must not be null.");
        if (secrets.isEmpty()) {
            return;
        }
        this.clusterLockOperator.maybePerformWithLock(() -> {
            this.secretServiceManagement.reloadConfiguration();
            HashSet<SealedSecret> sealed = new HashSet<SealedSecret>();
            for (Map.Entry secretToSecure : secrets.entrySet()) {
                Assert.hasText((String)((String)secretToSecure.getKey()), (String)"Secret identifier must not be empty.");
                DefaultSecretService.validateSecretDataSize((String)secretToSecure.getValue());
                log.debug("Putting secret {}", secretToSecure.getKey());
                sealed.add(this.backends.getDefaultBackend().seal((String)secretToSecure.getKey(), (String)secretToSecure.getValue()));
            }
            this.secretDao.put(sealed);
        });
    }

    public Optional<String> get(String identifier) throws SecretServiceException {
        Assert.hasText((String)identifier, (String)"Secret identifier must not be empty.");
        Map<String, Optional<String>> out = this.get(Collections.singleton(identifier));
        return out.getOrDefault(identifier, Optional.empty());
    }

    public Map<String, Optional<String>> get(Set<String> identifiers) throws SecretServiceException {
        Assert.notNull(identifiers, (String)"Identifiers must not be null.");
        if (identifiers.isEmpty()) {
            return Collections.emptyMap();
        }
        Map sealedMap = this.secretDao.get(identifiers);
        HashMap<String, Optional<String>> result = new HashMap<String, Optional<String>>(identifiers.size());
        for (String id : identifiers) {
            Optional maybeSealed = sealedMap.getOrDefault(id, Optional.empty());
            if (maybeSealed.isEmpty()) {
                result.put(id, Optional.empty());
                continue;
            }
            SealedSecret sealed = (SealedSecret)maybeSealed.get();
            SecretServiceBackend backend = this.getBackendForSecret(sealed);
            result.put(id, Optional.ofNullable(backend.unseal(sealed)));
        }
        return result;
    }

    public void delete(String identifier) throws SecretServiceException {
        Assert.hasText((String)identifier, (String)"Secret identifier must not be empty.");
        this.delete(Collections.singleton(identifier));
    }

    public void delete(Set<String> identifiers) throws SecretServiceException {
        Assert.notNull(identifiers, (String)"Identifiers must not be null.");
        if (identifiers.isEmpty()) {
            return;
        }
        this.clusterLockOperator.maybePerformWithLock(() -> {
            Map identifiersToSecrets = this.secretDao.get(identifiers);
            boolean hasAnySecrets = identifiersToSecrets.values().stream().anyMatch(Optional::isPresent);
            if (!hasAnySecrets) {
                return;
            }
            this.secretServiceManagement.reloadConfiguration();
            HashSet<String> secretsToDelete = new HashSet<String>();
            for (Map.Entry secret : identifiersToSecrets.entrySet()) {
                Optional maybeSecret = (Optional)secret.getValue();
                if (!maybeSecret.isPresent()) continue;
                SealedSecret sealed = (SealedSecret)maybeSecret.get();
                Optional<SecretServiceBackend> maybeBackend = this.backends.getBackend(sealed.getBackendId());
                if (maybeBackend.isEmpty()) {
                    throw new SecretServiceException("Cannot delete secret from unknown backend: " + sealed.getBackendId());
                }
                SecretServiceBackend backend = maybeBackend.get();
                backend.delete((String)secret.getKey());
                secretsToDelete.add((String)secret.getKey());
            }
            if (!secretsToDelete.isEmpty()) {
                this.secretDao.delete(secretsToDelete);
            }
        });
    }

    public SecretServiceConfiguration getConfiguration() {
        this.secretServiceManagement.reloadConfiguration();
        return this.backends.getConfiguration();
    }

    public SecretService.SecretServiceManagement getManagement() {
        return this.secretServiceManagement;
    }

    @Override
    public SecretServiceType getDefaultBackendType() {
        return this.backends.getDefaultBackend().getType();
    }

    @Override
    public void migrateTo(SecretServiceBackend newDefaultBackend) {
        this.backends.migrateTo(this.secretDao, newDefaultBackend);
    }

    @Override
    public SecretServiceConfig getCurrentConfig() {
        return this.backends.getCurrentSecretServiceConfig();
    }

    @Override
    public void reconfigure(Map<String, SecretServiceBackend> newBackends, String defaultBackendId) {
        log.info("Re-configuring SecretService to use new default backend: {}", (Object)defaultBackendId);
        this.backends.reconfigure(newBackends, defaultBackendId);
    }

    SecretServiceBackend getDefaultBackend() {
        return this.backends.getDefaultBackend();
    }

    private SecretServiceBackend getBackendForSecret(SealedSecret sealed) throws SecretServiceException {
        String backendId = sealed.getBackendId();
        Optional<SecretServiceBackend> maybeBackend = this.backends.getBackend(backendId);
        if (maybeBackend.isEmpty()) {
            this.secretServiceManagement.reloadConfiguration();
            maybeBackend = this.backends.getBackend(backendId);
            if (maybeBackend.isEmpty()) {
                throw new SecretServiceException("Cannot get secret from unknown backend: " + backendId);
            }
        }
        return maybeBackend.get();
    }
}

