/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service;

import com.atlassian.secrets.api.RotationState;
import com.atlassian.secrets.api.RotationStatus;
import com.atlassian.secrets.api.SecretKey;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceType;
import com.atlassian.secrets.service.DefaultSecretService;
import com.atlassian.secrets.service.SecretServiceBackend;
import com.atlassian.secrets.service.SecretServiceParams;
import com.atlassian.secrets.service.aes.AESBackendGenerator;
import com.atlassian.secrets.service.aes.AESConfig;
import com.atlassian.secrets.service.aes.AESEncryptionBackend;
import com.atlassian.secrets.service.aes.DefaultAESBackendGenerator;
import com.atlassian.secrets.service.clusterlock.ClusterLockOperator;
import com.atlassian.secrets.service.clusterlock.DefaultClusterLockOperator;
import com.atlassian.secrets.service.config.DefaultConfigSource;
import com.atlassian.secrets.service.config.DefaultSecretServiceConfigParser;
import com.atlassian.secrets.service.config.SecretConfigurationSource;
import com.atlassian.secrets.service.config.SecretServiceConfig;
import com.atlassian.secrets.service.config.SecretServiceConfigParser;
import com.atlassian.secrets.service.internal.DefaultSecretServiceInterface;
import com.atlassian.secrets.service.utils.FilesystemUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecretServiceManagement
implements SecretService.SecretServiceManagement {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretServiceManagement.class);
    public static final String ROTATION_FAILURE_MESSAGE = "Failure when performing AES key rotation:";
    public static final String ROTATION_COMPLETION_MESSAGE = "AES key rotation complete.";
    public static final String ROTATION_NOT_STARTED_BASE_MESSAGE = "Cannot rotate the AES key because ";
    public static final String ROTATION_NOT_STARTED_WRONG_CONFIG = "Cannot rotate the AES key because Secret Service is not configured for AES encryption";
    public static final String ROTATION_NOT_STARTED_NO_CLUSTER_LOCK = "Cannot rotate the AES key because key rotation is not supported without a cluster lock.";
    private final SecretConfigurationSource secretConfigurationSource;
    private final DefaultSecretServiceInterface defaultSecretService;
    private final AESBackendGenerator aesBackendGenerator;
    private final SecretServiceConfigParser configParser;
    private final SecretServiceParams secretServiceParams;
    private final ClusterLockOperator clusterLockOperator;

    public DefaultSecretServiceManagement(DefaultSecretService secretService, SecretServiceParams params) {
        this(secretService, new DefaultConfigSource(params), new DefaultAESBackendGenerator(), new DefaultSecretServiceConfigParser(), params);
    }

    DefaultSecretServiceManagement(DefaultSecretServiceInterface defaultSecretService, SecretConfigurationSource configurationSource, AESBackendGenerator aesBackendGenerator, SecretServiceConfigParser configParser, SecretServiceParams params) {
        this.defaultSecretService = defaultSecretService;
        this.secretConfigurationSource = configurationSource;
        this.aesBackendGenerator = aesBackendGenerator;
        this.configParser = configParser;
        this.secretServiceParams = params;
        this.clusterLockOperator = new DefaultClusterLockOperator(params.getClusterLockServiceSupplier());
    }

    public RotationStatus rotateAESKey() {
        SecretServiceType currentDefaultType = this.defaultSecretService.getDefaultBackendType();
        if (currentDefaultType != SecretServiceType.AES) {
            return new RotationStatus(RotationState.NOT_STARTED, Optional.of(ROTATION_NOT_STARTED_WRONG_CONFIG));
        }
        if (this.clusterLockOperator.getClusterLockServiceIfAvailable().isEmpty()) {
            return new RotationStatus(RotationState.NOT_IMPLEMENTED, Optional.of(ROTATION_NOT_STARTED_NO_CLUSTER_LOCK));
        }
        try {
            this.clusterLockOperator.performWithLock(() -> {
                AESEncryptionBackend aesEncryptionBackend = this.aesBackendGenerator.generate(this.secretServiceParams.getKeyDirectory());
                this.migrate(aesEncryptionBackend);
            });
            return new RotationStatus(RotationState.COMPLETED, Optional.of(ROTATION_COMPLETION_MESSAGE));
        }
        catch (Exception ex) {
            log.error("Failure when performing AES key rotation: {}", (Object)ex.getMessage());
            return new RotationStatus(RotationState.FAILED, Optional.of("Failure when performing AES key rotation: " + ex.getMessage()));
        }
    }

    public void reloadConfiguration() throws SecretServiceException {
        log.info("Re-loading SecretService configuration");
        SecretServiceConfig config = this.secretConfigurationSource.read();
        Map<String, SecretServiceBackend> backends = this.configParser.parseBackends(config, this.secretServiceParams);
        this.defaultSecretService.reconfigure(backends, config.getDefaultBackend());
    }

    public Set<SecretKey> getInactiveKeys() {
        HashSet allAesKeys = new HashSet();
        HashSet activeKeys = new HashSet();
        this.clusterLockOperator.performWithLock(() -> {
            allAesKeys.addAll(this.getAllAESKeys());
            activeKeys.addAll(this.getActiveKeys());
        });
        if (allAesKeys.isEmpty()) {
            return new HashSet<SecretKey>();
        }
        return allAesKeys.stream().filter(key -> !activeKeys.contains(key.path().getFileName().toString())).collect(Collectors.toSet());
    }

    private Set<String> getActiveKeys() {
        SecretServiceConfig config = this.secretConfigurationSource.read();
        return config.getBackends(SecretServiceType.AES).values().stream().map(backend -> DefaultSecretServiceConfigParser.mapToServiceConfig(backend.getProperties(), AESConfig.class).getKey().getFileName().toString()).collect(Collectors.toSet());
    }

    private Set<SecretKey> getAllAESKeys() {
        Set<SecretKey> allAesKeys;
        try {
            Path keyDirectory = this.secretServiceParams.getKeyDirectory();
            allAesKeys = FilesystemUtils.getAllFiles(keyDirectory).stream().filter(file -> file.getName().startsWith("ATL_SECRET_AES_256")).map(file -> new SecretKey(file.toPath())).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new SecretServiceException("Error reading the key directory", (Throwable)e);
        }
        return allAesKeys;
    }

    private void migrate(SecretServiceBackend newDefaultBackend) {
        this.reloadConfiguration();
        SecretServiceConfig currentConfig = this.defaultSecretService.getCurrentConfig();
        if (currentConfig.getBackends().containsKey(newDefaultBackend.getId())) {
            throw new SecretServiceException("Cannot perform migration as the new backend ID clashes with an existing backend");
        }
        currentConfig.getBackends().put(newDefaultBackend.getId(), newDefaultBackend.getBackendConfig());
        this.secretConfigurationSource.write(currentConfig);
        try {
            this.defaultSecretService.migrateTo(newDefaultBackend);
        }
        finally {
            currentConfig = this.defaultSecretService.getCurrentConfig();
            this.secretConfigurationSource.write(currentConfig);
        }
    }
}

