/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service;

import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SealedSecretFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;

public class EncryptionBasedSecret
implements SealedSecret {
    private final String backendId;
    private final String identifier;
    private final String algorithm;
    private final byte[] encryptedData;
    private final byte[] iv;
    private final byte[] keyHash;

    public EncryptionBasedSecret(@JsonProperty(value="identifier", required=true) String identifier, @JsonProperty(value="backendId", required=true) String backendId, @JsonProperty(value="algorithm", required=true) String algorithm, @JsonProperty(value="encryptedData", required=true) byte[] encryptedData, @JsonProperty(value="iv", required=true) byte[] iv, @JsonProperty(value="keyHash", required=true) byte[] keyHash) {
        this.identifier = identifier;
        this.backendId = backendId;
        this.algorithm = algorithm;
        this.encryptedData = encryptedData;
        this.iv = iv;
        this.keyHash = keyHash;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getBackendId() {
        return this.backendId;
    }

    public String toString() {
        return SealedSecretFormat.getFormat().toString(SealedSecretFormat.SecretType.ENCRYPTED, (SealedSecret)this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EncryptionBasedSecret)) {
            return false;
        }
        EncryptionBasedSecret otherSecret = (EncryptionBasedSecret)other;
        return this.identifier.equals(otherSecret.identifier) && this.backendId.equals(otherSecret.backendId) && this.algorithm.equals(otherSecret.algorithm) && Arrays.equals(this.encryptedData, otherSecret.encryptedData) && Arrays.equals(this.iv, otherSecret.iv) && Arrays.equals(this.keyHash, otherSecret.keyHash);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.backendId, this.algorithm, Arrays.hashCode(this.encryptedData), Arrays.hashCode(this.iv), Arrays.hashCode(this.keyHash));
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getKeyHash() {
        return this.keyHash;
    }
}

