/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.aes;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Path;
import java.util.Objects;

public class AESConfig {
    private static final String KEY_DIR_PLACEHOLDER = "AES_KEY_DIR";
    private final Path key;

    public AESConfig(@JsonProperty(value="key", required=true) Path key) {
        Objects.requireNonNull(key, "'key' field should be defined.");
        this.key = key;
    }

    @JsonProperty(value="key")
    public String getKeyAsString() {
        return Path.of(KEY_DIR_PLACEHOLDER, new String[0]).resolve(this.key.getFileName()).toString();
    }

    public Path getKey() {
        return this.key;
    }

    public AESConfig withResolvedKey(Path actualKeyDir) {
        if (this.key.startsWith(KEY_DIR_PLACEHOLDER)) {
            return new AESConfig(actualKeyDir.resolve(this.key.getFileName()));
        }
        return this;
    }
}

