/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.config;

import com.atlassian.secrets.api.SecretServiceType;
import com.atlassian.secrets.service.config.BackendConfig;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SecretServiceConfig {
    private final String defaultBackend;
    private final Map<String, BackendConfig> backends;

    public SecretServiceConfig(@JsonProperty(value="default", required=true) String defaultBackend, @JsonProperty(value="backends", required=true) Map<String, BackendConfig> backends) {
        Objects.requireNonNull(defaultBackend, "'default' field should be defined.");
        Objects.requireNonNull(backends, "'backends' field should be defined.");
        this.defaultBackend = defaultBackend;
        this.backends = backends;
    }

    @JsonProperty(value="default")
    public String getDefaultBackend() {
        return this.defaultBackend;
    }

    public Map<String, BackendConfig> getBackends() {
        return this.backends;
    }

    public Map<String, BackendConfig> getBackends(SecretServiceType type) {
        return this.backends.entrySet().stream().filter(entry -> ((BackendConfig)entry.getValue()).getType() == type).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretServiceConfig config = (SecretServiceConfig)o;
        return Objects.equals(this.defaultBackend, config.defaultBackend) && Objects.equals(this.backends, config.backends);
    }

    public int hashCode() {
        return Objects.hash(this.defaultBackend, this.backends);
    }
}

