/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.dao;

import com.atlassian.secrets.service.dao.IoBiConsumer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;

public class Underlock {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final Path file;
    private final Duration timeout;

    private Underlock(Path file, Duration timeout) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(timeout);
        this.file = file;
        this.timeout = timeout;
    }

    public static Underlock forFile(Path file) {
        return new Underlock(file, Duration.ZERO);
    }

    public static Underlock forFile(Path file, Duration timeout) {
        return new Underlock(Objects.requireNonNull(file, "file"), Objects.requireNonNull(timeout, "timeout"));
    }

    public void edit(IoBiConsumer<? super BufferedReader, ? super Writer> mutator, boolean withBackup) throws IOException, OverlappingFileLockException {
        try (LockedFile locked = this.acquireLock(true);){
            locked.edit(mutator, withBackup);
        }
    }

    public void editRaw(IoBiConsumer<? super InputStream, ? super OutputStream> mutator, boolean withBackup) throws IOException {
        Objects.requireNonNull(mutator, "mutator");
        try (LockedFile locked = this.acquireLock(true);){
            locked.editRaw(mutator, withBackup);
        }
    }

    public LockedFile lock() throws IOException, OverlappingFileLockException {
        return this.acquireLock(true);
    }

    public void lockIndefinitely(@Nullable String content) throws IOException, OverlappingFileLockException {
        try (LockedFile locked = this.acquireLock(false);){
            if (StringUtils.isNotBlank((CharSequence)content)) {
                locked.edit((ignored, writer) -> writer.write(content), false);
                locked.rollBack();
            }
        }
    }

    public void releaseIfNotHeld() throws IOException {
        this.releaseIfNotHeld(null);
    }

    public void releaseIfNotHeld(@Nullable Runnable cleanupTask) throws IOException {
        Path lockFile = this.getLockFile();
        try (FileChannel lockChannel = FileChannel.open(lockFile, StandardOpenOption.WRITE);
             FileLock lock = lockChannel.tryLock();){
            if (lock == null) {
                throw new OverlappingFileLockException();
            }
            if (cleanupTask != null) {
                cleanupTask.run();
            }
            Files.delete(lockFile);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
    }

    public void write(ReadableByteChannel source) throws IOException {
        try (LockedFile locked = this.acquireLock(true);){
            locked.write(source);
        }
    }

    private static InputStream newInputStream(Path file) throws IOException {
        try {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return null;
        }
    }

    private static BufferedReader newReader(Path file) throws IOException {
        try {
            return Files.newBufferedReader(file, StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return null;
        }
    }

    private static FileChannel openLockWithHardLink(Path lockFile) throws IOException {
        long n = RANDOM.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        Path temporaryLockFile = lockFile.resolveSibling("tmp-" + Long.toString(n, 16) + "-" + String.valueOf(lockFile.getFileName()));
        FileChannel lockChannel = FileChannel.open(temporaryLockFile, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        Exception caughtException = null;
        try {
            Files.createLink(lockFile, temporaryLockFile);
        }
        catch (FileAlreadyExistsException e) {
            caughtException = e;
            throw e;
        }
        catch (IOException | UnsupportedOperationException e) {
            try {
                FileChannel fileChannel = FileChannel.open(lockFile, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                return fileChannel;
            }
            catch (IOException suppressed) {
                e.addSuppressed(suppressed);
                caughtException = e;
                throw e;
            }
        }
        finally {
            if (caughtException != null) {
                try {
                    lockChannel.close();
                }
                catch (IOException suppressed) {
                    caughtException.addSuppressed(suppressed);
                }
            }
            try {
                Files.deleteIfExists(temporaryLockFile);
            }
            catch (IOException suppressed) {
                if (caughtException == null) {
                    throw suppressed;
                }
                caughtException.addSuppressed(suppressed);
            }
        }
        return lockChannel;
    }

    private LockedFile acquireLock(boolean deleteOnClose) throws IOException {
        Path lockFile = this.getLockFile();
        AbstractInterruptibleChannel lockChannel = null;
        FileLock lock = null;
        try {
            long deadline = System.nanoTime() + this.timeout.toNanos();
            long sleepNanos = 100000L;
            while (lock == null) {
                block10: {
                    try {
                        lockChannel = Underlock.openLockWithHardLink(lockFile);
                        lock = ((FileChannel)lockChannel).tryLock(0L, Long.MAX_VALUE, false);
                    }
                    catch (OverlappingFileLockException overlappingFileLockException) {
                    }
                    catch (FileAlreadyExistsException e) {
                        if (e.getFile().equals(lockFile.toString())) break block10;
                        throw e;
                    }
                }
                if (lock != null) continue;
                long curTime = System.nanoTime();
                if (curTime > deadline) {
                    throw new OverlappingFileLockException();
                }
                LockSupport.parkNanos(Math.min(deadline - curTime, sleepNanos));
                sleepNanos = Math.min(50000000L, sleepNanos * 2L);
            }
            return new DefaultLockedFile((FileChannel)lockChannel, lock, lockFile, deleteOnClose);
        }
        catch (IOException | RuntimeException exception) {
            try {
                if (lockChannel != null) {
                    lockChannel.close();
                }
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
            throw exception;
        }
    }

    private Path getLockFile() {
        return this.file.resolveSibling(String.valueOf(this.file.getFileName()) + ".lock");
    }

    public static interface LockedFile
    extends AutoCloseable {
        @Override
        public void close() throws IOException;

        public void edit(IoBiConsumer<? super BufferedReader, ? super Writer> var1, boolean var2) throws IOException;

        public void editRaw(IoBiConsumer<? super InputStream, ? super OutputStream> var1, boolean var2) throws IOException;

        public void rollBack();

        public void write(ReadableByteChannel var1) throws IOException;
    }

    private class DefaultLockedFile
    implements LockedFile {
        private final boolean deleteOnClose;
        private final FileLock lock;
        private final FileChannel lockChannel;
        private final Path lockFile;
        private volatile boolean closed;
        private volatile boolean staged;
        private volatile boolean withBackup;

        private DefaultLockedFile(FileChannel lockChannel, FileLock lock, Path lockFile, boolean deleteOnClose) {
            this.deleteOnClose = deleteOnClose;
            this.lockChannel = lockChannel;
            this.lock = lock;
            this.lockFile = lockFile;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            Exception exception = null;
            if (this.staged) {
                try {
                    if (this.withBackup) {
                        Files.move(Underlock.this.file, Underlock.this.file.resolveSibling(String.valueOf(Underlock.this.file.getFileName()) + ".bak"), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.deleteIfExists(Underlock.this.file);
                    }
                    Files.move(this.lockFile, Underlock.this.file, new CopyOption[0]);
                }
                catch (IOException | RuntimeException e) {
                    exception = e;
                }
            }
            try {
                this.lock.close();
            }
            catch (IOException | RuntimeException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            try {
                this.lockChannel.close();
            }
            catch (IOException | RuntimeException e) {
                if (exception == null) {
                    exception = e;
                }
                exception.addSuppressed(e);
            }
            if (this.deleteOnClose) {
                try {
                    Files.deleteIfExists(this.lockFile);
                }
                catch (IOException | RuntimeException e) {
                    if (exception == null) {
                        exception = e;
                    }
                    exception.addSuppressed(e);
                }
            }
            if (exception != null) {
                throw new IOException("Something went wrong :(", exception);
            }
            this.closed = true;
        }

        @Override
        public void edit(IoBiConsumer<? super BufferedReader, ? super Writer> mutator, boolean withBackup) throws IOException {
            this.checkLockHeld();
            Writer lockWriter = Channels.newWriter(this.lockChannel, StandardCharsets.UTF_8.newEncoder(), 8192);
            try (BufferedReader reader = Underlock.newReader(Underlock.this.file);){
                this.withBackup = withBackup && reader != null;
                mutator.accept(reader, lockWriter);
                this.staged = true;
            }
            lockWriter.flush();
        }

        @Override
        public void editRaw(IoBiConsumer<? super InputStream, ? super OutputStream> mutator, boolean withBackup) throws IOException {
            this.checkLockHeld();
            OutputStream lockOutput = Channels.newOutputStream(this.lockChannel);
            try (InputStream inputStream = Underlock.newInputStream(Underlock.this.file);){
                this.withBackup = withBackup && inputStream != null;
                mutator.accept(inputStream, lockOutput);
                this.staged = true;
            }
            lockOutput.flush();
        }

        @Override
        public void rollBack() {
            this.checkLockHeld();
            this.staged = false;
        }

        @Override
        public void write(ReadableByteChannel source) throws IOException {
            this.checkLockHeld();
            this.lockChannel.transferFrom(source, 0L, Long.MAX_VALUE);
            this.staged = true;
        }

        private void checkLockHeld() {
            if (this.closed) {
                throw new IllegalStateException("Lock on " + String.valueOf(Underlock.this.file) + " has already been released");
            }
        }
    }
}

