/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.file;

import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.file.FileWriteRequest;
import com.atlassian.secrets.service.file.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicFileWriter
implements FileWriter {
    private static final Logger log = LoggerFactory.getLogger(AtomicFileWriter.class);

    @Override
    public void write(FileWriteRequest request) throws SecretServiceException {
        if (request.ignoreIfExists() && Files.exists(request.file(), new LinkOption[0])) {
            log.debug("File {} already exists, ignoring", (Object)request.file());
            request.onFileCreated().accept(false);
            return;
        }
        Path tempFile = request.file().resolveSibling(String.valueOf(UUID.randomUUID()) + ".tmp");
        try {
            Files.writeString(tempFile, (CharSequence)request.data().get(), StandardCharsets.UTF_8, new OpenOption[0]);
            Files.move(tempFile, request.file(), StandardCopyOption.ATOMIC_MOVE);
            request.onFileCreated().accept(true);
        }
        catch (IOException e) {
            String errorMessage = String.format("Error writing file: %s", request.file());
            log.error(errorMessage, (Throwable)e);
            throw new SecretServiceException(errorMessage, (Throwable)e);
        }
        finally {
            if (Files.exists(tempFile, new LinkOption[0])) {
                try {
                    Files.delete(tempFile);
                }
                catch (IOException e) {
                    log.error("Error cleaning up tmp file", (Throwable)e);
                }
            }
        }
    }
}

