/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.file;

import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.dao.Underlock;
import com.atlassian.secrets.service.file.FileWriteRequest;
import com.atlassian.secrets.service.file.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.Duration;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnderlockFileWriter
implements FileWriter {
    private static final Logger log = LoggerFactory.getLogger(UnderlockFileWriter.class);
    private static final Duration UNDERLOCK_TIMEOUT = Duration.ofSeconds(30L);

    @Override
    public void write(FileWriteRequest request) throws SecretServiceException {
        Underlock lockedFile = Underlock.forFile(request.file(), UNDERLOCK_TIMEOUT);
        try {
            lockedFile.edit((reader, writer) -> {
                if (request.ignoreIfExists() && reader != null) {
                    log.debug("File {} already exists, ignoring", (Object)request.file());
                    this.write((Writer)writer, reader.lines().collect(Collectors.joining(System.lineSeparator())));
                    request.onFileCreated().accept(false);
                    return;
                }
                writer.write(request.data().get());
                request.onFileCreated().accept(true);
            }, false);
        }
        catch (IOException e) {
            throw new SecretServiceException(String.format("Problem writing request '%s'", request), (Throwable)e);
        }
    }

    private void write(Writer writer, String data) {
        try {
            writer.write(data);
        }
        catch (IOException e) {
            throw new SecretServiceException((Throwable)e);
        }
    }
}

