/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.internal;

import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.SecretServiceBackend;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationHelpers {
    private static final Logger log = LoggerFactory.getLogger(MigrationHelpers.class);

    private MigrationHelpers() {
    }

    public static void migrate(SecretDao secretDao, SecretServiceBackend origin, SecretServiceBackend destination) throws SecretServiceException {
        Set idsToMigrate = secretDao.getIdsForBackend(origin.getId());
        if (idsToMigrate.isEmpty()) {
            return;
        }
        HashSet<SealedSecret> migratedSecrets = new HashSet<SealedSecret>();
        for (Object secretId : idsToMigrate) {
            Optional maybeSealedSecret = secretDao.get((String)secretId);
            if (maybeSealedSecret.isEmpty()) {
                log.info("Secret {} won't be migrated as it has been deleted", secretId);
                continue;
            }
            SealedSecret sealedSecret = (SealedSecret)maybeSealedSecret.get();
            String secretValue = origin.unseal(sealedSecret);
            migratedSecrets.add(destination.seal((String)secretId, secretValue));
        }
        secretDao.put(migratedSecrets);
        HashSet<String> cleanedUpSecrets = new HashSet<String>();
        try {
            for (String secretId : idsToMigrate) {
                origin.delete(secretId);
                cleanedUpSecrets.add(secretId);
            }
        }
        catch (Exception e) {
            idsToMigrate.removeAll(cleanedUpSecrets);
            String idsRemaining = String.join((CharSequence)", ", idsToMigrate);
            log.error("Error cleaning up secrets post migration", (Throwable)e);
            log.error("Secrets which were not cleaned up: {}", (Object)idsRemaining);
        }
    }
}

