/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue;

import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheckResult;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;

public record CombinedPreAcceptMergeResults(@Nonnull Collection<PreAcceptMergeCheckResult> results) {
    public CombinedPreAcceptMergeResults {
        results = Objects.requireNonNull(results, "results").stream().map(result -> Objects.requireNonNull(result, "result")).toList();
    }

    @Nonnull
    public PreAcceptMergeCheckResult.State getEffectiveState() {
        PreAcceptMergeCheckResult.State effectiveState = PreAcceptMergeCheckResult.State.ACCEPTED;
        for (PreAcceptMergeCheckResult result : this.results) {
            if (result.getState() == PreAcceptMergeCheckResult.State.REJECTED) {
                return PreAcceptMergeCheckResult.State.REJECTED;
            }
            if (result.getState() != PreAcceptMergeCheckResult.State.PENDING) continue;
            effectiveState = PreAcceptMergeCheckResult.State.PENDING;
        }
        return effectiveState;
    }
}

