/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.dmz.features.RequireDarkFeature;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.dmz.mergequeue.QueuedPullRequestSearchRequest;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mergequeue.MergeQueueExecutorTask;
import com.atlassian.bitbucket.internal.mergequeue.MergeQueueNotEnabledException;
import com.atlassian.bitbucket.internal.mergequeue.MergeQueueProcessor;
import com.atlassian.bitbucket.internal.mergequeue.concurrent.MergeQueueEntryLock;
import com.atlassian.bitbucket.internal.mergequeue.dao.MergeQueueDao;
import com.atlassian.bitbucket.internal.mergequeue.event.MergeQueueItemAddedEvent;
import com.atlassian.bitbucket.internal.mergequeue.event.MergeQueueItemProcessedEvent;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mergequeue.InternalMergeQueueEntry;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;

@AvailableToPlugins(value=MergeQueueService.class)
@Service(value="mergeQueueService")
public class DefaultMergeQueueService
implements MergeQueueService {
    private static final String BUCKETED_EXECUTOR_NAME = "merge-queue-executor";
    private final AuthenticationContext authenticationContext;
    private final BucketedExecutor<MergeQueueExecutorTask> bucketedExecutor;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final MergeQueueDao mergeQueueDao;
    private final MergeQueueEntryLock mergeQueueEntryLock;
    private final MergeQueueSettingsService mergeQueueSettingsService;
    private final DmzPullRequestService pullRequestService;
    private final TransactionSynchronizer transactionSynchronizer;

    public DefaultMergeQueueService(AuthenticationContext authenticationContext, ConcurrencyService concurrencyService, EventPublisher eventPublisher, I18nService i18nService, MergeQueueDao mergeQueueDao, MergeQueueEntryLock mergeQueueEntryLock, MergeQueueProcessor mergeQueueProcessor, MergeQueueSettingsService mergeQueueSettingsService, DmzPullRequestService pullRequestService, TransactionSynchronizer transactionSynchronizer) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.mergeQueueDao = mergeQueueDao;
        this.mergeQueueEntryLock = mergeQueueEntryLock;
        this.mergeQueueSettingsService = mergeQueueSettingsService;
        this.pullRequestService = pullRequestService;
        this.transactionSynchronizer = transactionSynchronizer;
        this.bucketedExecutor = concurrencyService.getBucketedExecutor(BUCKETED_EXECUTOR_NAME, new BucketedExecutorSettings.Builder(MergeQueueExecutorTask::toBucketId, (BucketProcessor)mergeQueueProcessor).maxConcurrency(1, ConcurrencyPolicy.PER_NODE).maxAttempts(1).build());
    }

    @RequireDarkFeature(value="merge.queue")
    @PreAuthorize(value="hasRepositoryPermission(#mergeRequest?.getRepositoryId, 'REPO_WRITE')")
    @Transactional
    public void addToQueue(@Nonnull PullRequestMergeRequest mergeRequest) {
        Objects.requireNonNull(mergeRequest, "mergeRequest");
        PullRequest pullRequest = this.pullRequestService.getById(mergeRequest.getRepositoryId(), mergeRequest.getPullRequestId());
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.repository.nosuchrequest", new Object[]{mergeRequest.getRepositoryId(), mergeRequest.getPullRequestId()}));
        }
        if (!this.mergeQueueSettingsService.isEnabled(pullRequest)) {
            throw new MergeQueueNotEnabledException(this.i18nService.createKeyedMessage("bitbucket.mergequeue.not-enabled", new Object[0]));
        }
        if (pullRequest.getState() != PullRequestState.OPEN || pullRequest.isDraft()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.mergequeue.pull-request.not-open", new Object[0]));
        }
        final Repository repository = pullRequest.getToRef().getRepository();
        PullRequestMergeability mergeability = this.pullRequestService.canMerge(repository.getId(), pullRequest.getId(), true);
        if (mergeability.isConflicted()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.mergequeue.pull-request.conflicted", new Object[0]));
        }
        if (!mergeability.getVetoes().isEmpty()) {
            throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.mergequeue.pull-request.merge-check-vetos", new Object[0]));
        }
        InternalMergeQueueEntry entry = new InternalMergeQueueEntry.Builder(pullRequest, this.getCurrentUserOrThrow()).autoSubject(mergeRequest.isAutoSubject()).message(mergeRequest.getMessage()).strategyId(mergeRequest.getStrategyId()).build();
        this.mergeQueueDao.create(entry);
        this.eventPublisher.publish((Object)new MergeQueueItemAddedEvent(this, pullRequest));
        this.transactionSynchronizer.register(new TransactionSynchronization(){

            public void afterCommit() {
                DefaultMergeQueueService.this.bucketedExecutor.submit((Serializable)new MergeQueueExecutorTask(repository.getId()));
            }
        });
    }

    @PreAuthorize(value="hasRepositoryPermission(#pullRequest?.toRef.repository, 'REPO_READ')")
    @Transactional(readOnly=true)
    public boolean isQueued(@Nonnull PullRequest pullRequest) {
        InternalMergeQueueEntry mergeQueueEntry = (InternalMergeQueueEntry)this.mergeQueueDao.getById(pullRequest.getId());
        return mergeQueueEntry != null;
    }

    @EventListener
    public void onMergeQueueItemProcessedEvent(MergeQueueItemProcessedEvent event) {
        event.getPullRequest().ifPresent(pullRequest -> event.getTimeoutAfter().ifPresent(timeoutIn -> this.bucketedExecutor.schedule((Serializable)new MergeQueueExecutorTask(event.getRepository().getId()), timeoutIn.toMillis(), TimeUnit.MILLISECONDS)));
    }

    @PreAuthorize(value="hasRepositoryPermission(#pullRequest?.toRef.repository, 'REPO_WRITE')")
    @Transactional
    public boolean removeFromQueue(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        int count = (Integer)this.mergeQueueEntryLock.withLock(pullRequest, () -> this.mergeQueueDao.deleteByRepositoryScopedId(pullRequest.getToRef().getRepository().getId(), pullRequest.getId()));
        return count > 0;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request?.toRepositoryId, 'REPO_READ')")
    @Transactional(readOnly=true)
    public Page<PullRequest> searchQueuedPullRequests(@Nonnull QueuedPullRequestSearchRequest request, @Nonnull PageRequest pageRequest) {
        return PageUtils.asPageOf(PullRequest.class, this.mergeQueueDao.searchQueuedPullRequests(request, pageRequest));
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void triggerChecks(@Nonnull Repository repository) {
        this.bucketedExecutor.submit((Serializable)new MergeQueueExecutorTask(repository.getId()));
    }

    private ApplicationUser getCurrentUserOrThrow() {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mergequeue.pull-request.anonymous", new Object[0]));
        }
        return currentUser;
    }
}

