/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue;

import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.dmz.features.RequireDarkFeature;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettings;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.dmz.mergequeue.SetMergeQueueSettingsRequest;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mergequeue.dao.MergeQueueSettingsDao;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.mergequeue.InternalMergeQueueSettings;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class DefaultMergeQueueSettingsService
implements MergeQueueSettingsService {
    @VisibleForTesting
    static final String MERGE_QUEUE_PROTECTED_BRANCH_GLOBAL = "mergequeue.protected-branch";
    @VisibleForTesting
    static final String MERGE_QUEUE_PROTECTED_BRANCH_REPO = "mergequeue.protected-branch.repo.%d";
    static final String MERGE_QUEUE_STALE_BRANCH_CLEANUP_CHANCE = "mergequeue.stale-branch-cleanup.chance";
    private static final Logger log = LoggerFactory.getLogger(DefaultMergeQueueSettingsService.class);
    private static final double DEFAULT_STALE_MERGE_CLEANUP_CHANCE = 0.01;
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final DarkFeatureManager darkFeatureManager;
    private final Duration defaultMergeTimeout;
    private final I18nService i18nService;
    private final MergeQueueSettingsDao mergeQueueSettingsDao;
    private final PermissionValidationService permissionValidationService;
    private final ProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final PullRequestService pullRequestService;
    private final RefService refService;
    private final double staleBranchCleanupChance;

    public DefaultMergeQueueSettingsService(InternalApplicationPropertiesService applicationPropertiesService, DarkFeatureManager darkFeatureManager, Duration defaultMergeTimeout, MergeQueueSettingsDao mergeQueueSettingsDao, I18nService i18nService, PermissionValidationService permissionValidationService, ProjectSettingsRestrictionService projectSettingsRestrictionService, PullRequestService pullRequestService, RefService refService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.darkFeatureManager = darkFeatureManager;
        this.defaultMergeTimeout = defaultMergeTimeout;
        this.i18nService = i18nService;
        this.mergeQueueSettingsDao = mergeQueueSettingsDao;
        this.permissionValidationService = permissionValidationService;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.pullRequestService = pullRequestService;
        this.refService = refService;
        this.staleBranchCleanupChance = DefaultMergeQueueSettingsService.initStaleBranchCleanupChance(applicationPropertiesService.getProperty(MERGE_QUEUE_STALE_BRANCH_CLEANUP_CHANCE, 0.01));
    }

    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public void deleteSettingsFor(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.mergeQueueSettingsDao.deleteByRepositoryIds(Set.of(Integer.valueOf(repository.getId())));
    }

    public Duration getDefaultMergeTimeout() {
        return this.defaultMergeTimeout;
    }

    @Nonnull
    @Transactional(readOnly=true)
    @Secured(value="Secured using explicit permission check")
    public MergeQueueSettings getInheritedOrDefault(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        if (scope.getType() == ScopeType.GLOBAL) {
            return DEFAULT_SETTINGS;
        }
        Scope effectiveScope = (Scope)scope.accept((ScopeVisitor)new ScopeVisitor<Scope>(){

            public Scope visit(@Nonnull ProjectScope scope) {
                DefaultMergeQueueSettingsService.this.permissionValidationService.validateForProject(scope.getProject(), Permission.PROJECT_READ);
                return scope;
            }

            public Scope visit(@Nonnull RepositoryScope scope) {
                DefaultMergeQueueSettingsService.this.permissionValidationService.validateForRepository(scope.getRepository(), Permission.REPO_READ);
                Project project = scope.getProject();
                if (DefaultMergeQueueSettingsService.this.projectSettingsRestrictionService.hasRestriction(project, ProjectSettingsRestrictionKeys.MERGE_QUEUE)) {
                    log.trace("Merge queue settings restricted, using settings from project {}", (Object)project.getKey());
                    return Scopes.project((Project)project);
                }
                return scope;
            }
        });
        return (MergeQueueSettings)ObjectUtils.firstNonNull((Object[])new MergeQueueSettings[]{this.mergeQueueSettingsDao.findInheritedSettings(effectiveScope), DEFAULT_SETTINGS});
    }

    public double getStaleBranchCleanupChance() {
        return this.staleBranchCleanupChance;
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRepositoryPermission(#repositoryId, 'REPO_READ')")
    public boolean isEnabled(int repositoryId, long pullRequestId) {
        if (!this.isFeatureEnabled()) {
            log.trace("Merge queue feature not enabled");
            return false;
        }
        PullRequest pullRequest = this.pullRequestService.getById(repositoryId, pullRequestId);
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.mergequeue.pull-request.not-found", new Object[]{repositoryId, pullRequestId}));
        }
        return this.isEnabled(pullRequest);
    }

    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRepositoryPermission(#pullRequest.toRef.repository, 'REPO_READ')")
    public boolean isEnabled(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        if (!this.isFeatureEnabled()) {
            log.trace("Merge queue feature not enabled");
            return false;
        }
        PullRequestRef toRef = pullRequest.getToRef();
        Repository repository = toRef.getRepository();
        boolean isEnabledForRepo = this.getInheritedOrDefault((Scope)Scopes.repository((Repository)repository)).isEnabled();
        if (!isEnabledForRepo) {
            log.trace("Merge queue not enabled for repository {}", (Object)repository.getId());
            return false;
        }
        if (this.isEnabledForBranch(repository, toRef.getId())) {
            log.trace("Merge queue enabled for repository {}, branch {}", (Object)repository.getId(), (Object)toRef.getId());
            return true;
        }
        log.trace("Merge queue not enabled for repository {}, branch {}", (Object)repository.getId(), (Object)toRef.getId());
        return false;
    }

    @Nonnull
    @Transactional
    @Secured(value="Secured using explicit permission check")
    @RequireDarkFeature(value="merge.queue")
    public MergeQueueSettings set(@Nonnull SetMergeQueueSettingsRequest request) {
        Objects.requireNonNull(request, "request");
        this.validateIsScopeConfigurable(request.getScope());
        this.validateAdminPermission(request.getScope());
        this.validateIsNotRestricted(request.getScope());
        InternalMergeQueueSettings existingSettings = this.mergeQueueSettingsDao.findByScope(request.getScope());
        if (existingSettings == null) {
            InternalMergeQueueSettings.Builder builder = new InternalMergeQueueSettings.Builder(request.getScope()).enabled(request.isEnabled());
            request.getMergeTimeout().ifPresent(arg_0 -> ((InternalMergeQueueSettings.Builder)builder).mergeTimeout(arg_0));
            InternalMergeQueueSettings newSettings = builder.build();
            log.debug("Creating new merge queue settings {}", (Object)newSettings);
            return (MergeQueueSettings)this.mergeQueueSettingsDao.create(newSettings);
        }
        InternalMergeQueueSettings.Builder builder = new InternalMergeQueueSettings.Builder(existingSettings).enabled(request.isEnabled());
        request.getMergeTimeout().ifPresentOrElse(arg_0 -> ((InternalMergeQueueSettings.Builder)builder).mergeTimeout(arg_0), () -> builder.mergeTimeout(Duration.ZERO));
        InternalMergeQueueSettings updatedSettings = builder.build();
        if (Objects.equals(existingSettings, updatedSettings)) {
            log.debug("Update request {} matches existing merge queue settings {}, no changes required", (Object)updatedSettings, (Object)existingSettings);
            return existingSettings;
        }
        log.debug("Update merge queue settings from {} to {}", (Object)existingSettings, (Object)updatedSettings);
        return (MergeQueueSettings)this.mergeQueueSettingsDao.update(updatedSettings);
    }

    private static double initStaleBranchCleanupChance(double value) {
        if (value < 0.0 || value > 1.0) {
            log.warn("Invalid value {} specified for property {}, using default value of {}", new Object[]{value, MERGE_QUEUE_STALE_BRANCH_CLEANUP_CHANCE, 0.01});
            return 0.01;
        }
        return value;
    }

    private boolean isEnabledForBranch(Repository repository, String branch) {
        String mergeQueueProtectedBranch = this.applicationPropertiesService.getProperty(MERGE_QUEUE_PROTECTED_BRANCH_REPO.formatted(repository.getId()));
        if (StringUtils.isBlank((String)mergeQueueProtectedBranch)) {
            mergeQueueProtectedBranch = this.applicationPropertiesService.getProperty(MERGE_QUEUE_PROTECTED_BRANCH_GLOBAL);
        }
        if (StringUtils.isBlank((String)mergeQueueProtectedBranch)) {
            mergeQueueProtectedBranch = this.refService.getDefaultBranch(repository).getId();
        }
        return branch.equals(GitRefPattern.HEADS.qualify(mergeQueueProtectedBranch));
    }

    private boolean isFeatureEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers("merge.queue").orElse(false);
    }

    private void validateAdminPermission(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultMergeQueueSettingsService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultMergeQueueSettingsService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateIsNotRestricted(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                if (DefaultMergeQueueSettingsService.this.projectSettingsRestrictionService.hasRestriction(repositoryScope.getProject(), ProjectSettingsRestrictionKeys.MERGE_QUEUE)) {
                    throw new ForbiddenException(DefaultMergeQueueSettingsService.this.i18nService.createKeyedMessage("bitbucket.mergequeue.settings.projectrestricted", new Object[]{repositoryScope.getProject().getKey(), repositoryScope.getRepository().getSlug()}));
                }
                return null;
            }
        });
    }

    private void validateIsScopeConfigurable(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope projectScope) {
                throw new ArgumentValidationException(DefaultMergeQueueSettingsService.this.i18nService.createKeyedMessage("bitbucket.mergequeue.settings.invalidscope", new Object[0]));
            }
        });
    }
}

