/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mergequeue;

import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.dmz.mergequeue.PullRequestMergeService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultPullRequestMergeService
implements PullRequestMergeService {
    private final MergeQueueService mergeQueueService;
    private final MergeQueueSettingsService mergeQueueSettingsService;
    private final InternalPullRequestService pullRequestService;

    public DefaultPullRequestMergeService(MergeQueueService mergeQueueService, MergeQueueSettingsService mergeQueueSettingsService, InternalPullRequestService pullRequestService) {
        this.mergeQueueService = mergeQueueService;
        this.mergeQueueSettingsService = mergeQueueSettingsService;
        this.pullRequestService = pullRequestService;
    }

    @Nonnull
    public PullRequest merge(@Nonnull PullRequestMergeRequest mergeRequest, boolean autoMerge) {
        Objects.requireNonNull(mergeRequest, "mergeRequest");
        if (this.mergeQueueSettingsService.isEnabled(mergeRequest.getRepositoryId(), mergeRequest.getPullRequestId())) {
            this.mergeQueueService.addToQueue(mergeRequest);
            return this.pullRequestService.getById(mergeRequest.getRepositoryId(), mergeRequest.getPullRequestId());
        }
        return autoMerge ? this.pullRequestService.autoMerge(mergeRequest) : this.pullRequestService.merge(mergeRequest);
    }
}

